/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;

public abstract class LogFactory {
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    protected static Hashtable factories = new Hashtable();

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public static LogFactory getFactory() throws LogConfigurationException {
        Object object;
        Object object2;
        Object object3;
        Properties properties;
        LogFactory logFactory;
        ClassLoader classLoader;
        block19: {
            classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return LogFactory.getContextClassLoader();
                }
            });
            logFactory = LogFactory.getCachedFactory(classLoader);
            if (logFactory != null) {
                return logFactory;
            }
            properties = null;
            try {
                object3 = LogFactory.getResourceAsStream(classLoader, FACTORY_PROPERTIES);
                if (object3 != null) {
                    properties = new Properties();
                    properties.load((InputStream)object3);
                    ((InputStream)object3).close();
                }
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                object3 = System.getProperty(FACTORY_PROPERTY);
                if (object3 != null) {
                    logFactory = LogFactory.newFactory((String)object3, classLoader);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (logFactory == null) {
                try {
                    object3 = LogFactory.getResourceAsStream(classLoader, SERVICE_ID);
                    if (object3 == null) break block19;
                    try {
                        object2 = new BufferedReader(new InputStreamReader((InputStream)object3, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        object2 = new BufferedReader(new InputStreamReader((InputStream)object3));
                    }
                    object = ((BufferedReader)object2).readLine();
                    ((BufferedReader)object2).close();
                    if (object != null && !"".equals(object)) {
                        logFactory = LogFactory.newFactory((String)object, classLoader);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (logFactory == null && properties != null && (object3 = properties.getProperty(FACTORY_PROPERTY)) != null) {
            logFactory = LogFactory.newFactory((String)object3, classLoader);
        }
        if (logFactory == null) {
            logFactory = LogFactory.newFactory(FACTORY_DEFAULT, LogFactory.class.getClassLoader());
        }
        if (logFactory != null) {
            LogFactory.cacheFactory(classLoader, logFactory);
            if (properties != null) {
                object = properties.propertyNames();
                while (object.hasMoreElements()) {
                    object3 = (String)object.nextElement();
                    object2 = properties.getProperty((String)object3);
                    logFactory.setAttribute((String)object3, object2);
                }
            }
        }
        return logFactory;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String string) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(ClassLoader classLoader) {
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            LogFactory logFactory = (LogFactory)factories.get(classLoader);
            if (logFactory != null) {
                logFactory.release();
                factories.remove(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAll() {
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            Enumeration enumeration = factories.elements();
            while (enumeration.hasMoreElements()) {
                LogFactory logFactory = (LogFactory)enumeration.nextElement();
                logFactory.release();
            }
            factories.clear();
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            Method method = Thread.class.getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new LogConfigurationException("Unexpected IllegalAccessException", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!(invocationTargetException.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException("Unexpected InvocationTargetException", invocationTargetException.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            classLoader = LogFactory.class.getClassLoader();
        }
        return classLoader;
    }

    private static LogFactory getCachedFactory(ClassLoader classLoader) {
        LogFactory logFactory = null;
        if (classLoader != null) {
            logFactory = (LogFactory)factories.get(classLoader);
        }
        return logFactory;
    }

    private static void cacheFactory(ClassLoader classLoader, LogFactory logFactory) {
        if (classLoader != null && logFactory != null) {
            factories.put(classLoader, logFactory);
        }
    }

    protected static LogFactory newFactory(final String string, final ClassLoader classLoader) throws LogConfigurationException {
        Object t2 = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class<?> clazz = null;
                try {
                    block10: {
                        if (classLoader != null) {
                            try {
                                clazz = classLoader.loadClass(string);
                                return (LogFactory)clazz.newInstance();
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                if (classLoader == LogFactory.class.getClassLoader()) {
                                    throw classNotFoundException;
                                }
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                if (classLoader == LogFactory.class.getClassLoader()) {
                                    throw noClassDefFoundError;
                                }
                            }
                            catch (ClassCastException classCastException) {
                                if (classLoader != LogFactory.class.getClassLoader()) break block10;
                                throw classCastException;
                            }
                        }
                    }
                    clazz = Class.forName(string);
                    return (LogFactory)clazz.newInstance();
                }
                catch (Exception exception) {
                    if (clazz != null && !LogFactory.class.isAssignableFrom(clazz)) {
                        return new LogConfigurationException("The chosen LogFactory implementation does not extend LogFactory. Please check your configuration.", exception);
                    }
                    return new LogConfigurationException(exception);
                }
            }
        });
        if (t2 instanceof LogConfigurationException) {
            throw (LogConfigurationException)t2;
        }
        return (LogFactory)t2;
    }

    private static InputStream getResourceAsStream(final ClassLoader classLoader, final String string) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(string);
                }
                return ClassLoader.getSystemResourceAsStream(string);
            }
        });
    }
}

