/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

public final class TimeoutController {
    private TimeoutController() {
    }

    public static void execute(Thread thread, long l2) throws TimeoutException {
        thread.start();
        try {
            thread.join(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (thread.isAlive()) {
            thread.interrupt();
            throw new TimeoutException();
        }
    }

    public static void execute(Runnable runnable, long l2) throws TimeoutException {
        Thread thread = new Thread(runnable, "Timeout guard");
        thread.setDaemon(true);
        TimeoutController.execute(thread, l2);
    }

    public static class TimeoutException
    extends Exception {
    }
}

