/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;

public class ParameterParser {
    private char[] chars = null;
    private int pos = 0;
    private int len = 0;
    private int i1 = 0;
    private int i2 = 0;

    private boolean hasChar() {
        return this.pos < this.len;
    }

    private String getToken(boolean bl2) {
        while (this.i1 < this.i2 && Character.isWhitespace(this.chars[this.i1])) {
            ++this.i1;
        }
        while (this.i2 > this.i1 && Character.isWhitespace(this.chars[this.i2 - 1])) {
            --this.i2;
        }
        if (bl2 && this.i2 - this.i1 >= 2 && this.chars[this.i1] == '\"' && this.chars[this.i2 - 1] == '\"') {
            ++this.i1;
            --this.i2;
        }
        String string = null;
        if (this.i2 >= this.i1) {
            string = new String(this.chars, this.i1, this.i2 - this.i1);
        }
        return string;
    }

    private boolean isOneOf(char c2, char[] cArray) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (c2 != cArray[i2]) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    private String parseToken(char[] cArray) {
        char c2;
        this.i1 = this.pos;
        this.i2 = this.pos;
        while (this.hasChar() && !this.isOneOf(c2 = this.chars[this.pos], cArray)) {
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(false);
    }

    private String parseQuotedToken(char[] cArray) {
        this.i1 = this.pos;
        this.i2 = this.pos;
        boolean bl2 = false;
        boolean bl3 = false;
        while (this.hasChar()) {
            char c2 = this.chars[this.pos];
            if (!bl2 && this.isOneOf(c2, cArray)) break;
            if (!bl3 && c2 == '\"') {
                bl2 = !bl2;
            }
            bl3 = !bl3 && c2 == '\\';
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(true);
    }

    public List parse(String string, char c2) {
        if (string == null) {
            return new ArrayList();
        }
        return this.parse(string.toCharArray(), c2);
    }

    public List parse(char[] cArray, char c2) {
        if (cArray == null) {
            return new ArrayList();
        }
        return this.parse(cArray, 0, cArray.length, c2);
    }

    public List parse(char[] cArray, int n2, int n3, char c2) {
        if (cArray == null) {
            return new ArrayList();
        }
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        this.chars = cArray;
        this.pos = n2;
        this.len = n3;
        String string = null;
        String string2 = null;
        while (this.hasChar()) {
            string = this.parseToken(new char[]{'=', c2});
            string2 = null;
            if (this.hasChar() && cArray[this.pos] == '=') {
                ++this.pos;
                string2 = this.parseQuotedToken(new char[]{c2});
            }
            if (this.hasChar() && cArray[this.pos] == c2) {
                ++this.pos;
            }
            if (string == null || string.equals("") && string2 == null) continue;
            arrayList.add(new NameValuePair(string, string2));
        }
        return arrayList;
    }
}

