/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import org.apache.commons.httpclient.NameValuePair;

public class ParameterFormatter {
    private static final char[] SEPARATORS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};
    private static final char[] UNSAFE_CHARS = new char[]{'\"', '\\'};
    private boolean alwaysUseQuotes = true;

    private static boolean isOneOf(char[] cArray, char c2) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (c2 != cArray[i2]) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnsafeChar(char c2) {
        return ParameterFormatter.isOneOf(UNSAFE_CHARS, c2);
    }

    private static boolean isSeparator(char c2) {
        return ParameterFormatter.isOneOf(SEPARATORS, c2);
    }

    public boolean isAlwaysUseQuotes() {
        return this.alwaysUseQuotes;
    }

    public void setAlwaysUseQuotes(boolean bl2) {
        this.alwaysUseQuotes = bl2;
    }

    public static void formatValue(StringBuffer stringBuffer, String string, boolean bl2) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Value buffer may not be null");
        }
        if (bl2) {
            stringBuffer.append('\"');
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (ParameterFormatter.isUnsafeChar(c2)) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
            }
            stringBuffer.append('\"');
        } else {
            int n2 = stringBuffer.length();
            boolean bl3 = false;
            for (int i3 = 0; i3 < string.length(); ++i3) {
                char c3 = string.charAt(i3);
                if (ParameterFormatter.isSeparator(c3)) {
                    bl3 = true;
                }
                if (ParameterFormatter.isUnsafeChar(c3)) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c3);
            }
            if (bl3) {
                stringBuffer.insert(n2, '\"');
                stringBuffer.append('\"');
            }
        }
    }

    public void format(StringBuffer stringBuffer, NameValuePair nameValuePair) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (nameValuePair == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        stringBuffer.append(nameValuePair.getName());
        String string = nameValuePair.getValue();
        if (string != null) {
            stringBuffer.append("=");
            ParameterFormatter.formatValue(stringBuffer, string, this.alwaysUseQuotes);
        }
    }

    public String format(NameValuePair nameValuePair) {
        StringBuffer stringBuffer = new StringBuffer();
        this.format(stringBuffer, nameValuePair);
        return stringBuffer.toString();
    }
}

