/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpConnectionManager;

public class IdleConnectionTimeoutThread
extends Thread {
    private List connectionManagers = new ArrayList();
    private boolean shutdown = false;
    private long timeoutInterval = 1000L;
    private long connectionTimeout = 3000L;

    public IdleConnectionTimeoutThread() {
        this.setDaemon(true);
    }

    public synchronized void addConnectionManager(HttpConnectionManager httpConnectionManager) {
        if (this.shutdown) {
            throw new IllegalStateException("IdleConnectionTimeoutThread has been shutdown");
        }
        this.connectionManagers.add(httpConnectionManager);
    }

    public synchronized void removeConnectionManager(HttpConnectionManager httpConnectionManager) {
        if (this.shutdown) {
            throw new IllegalStateException("IdleConnectionTimeoutThread has been shutdown");
        }
        this.connectionManagers.remove(httpConnectionManager);
    }

    protected void handleCloseIdleConnections(HttpConnectionManager httpConnectionManager) {
        httpConnectionManager.closeIdleConnections(this.connectionTimeout);
    }

    public synchronized void run() {
        while (!this.shutdown) {
            for (HttpConnectionManager httpConnectionManager : this.connectionManagers) {
                this.handleCloseIdleConnections(httpConnectionManager);
            }
            try {
                this.wait(this.timeoutInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.connectionManagers.clear();
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.notifyAll();
    }

    public synchronized void setConnectionTimeout(long l2) {
        if (this.shutdown) {
            throw new IllegalStateException("IdleConnectionTimeoutThread has been shutdown");
        }
        this.connectionTimeout = l2;
    }

    public synchronized void setTimeoutInterval(long l2) {
        if (this.shutdown) {
            throw new IllegalStateException("IdleConnectionTimeoutThread has been shutdown");
        }
        this.timeoutInterval = l2;
    }
}

