/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdleConnectionHandler {
    private static final Log LOG = LogFactory.getLog(IdleConnectionHandler.class);
    private Map connectionToAdded = new HashMap();

    public void add(HttpConnection httpConnection) {
        Long l2 = new Long(System.currentTimeMillis());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding connection at: " + l2);
        }
        this.connectionToAdded.put(httpConnection, l2);
    }

    public void remove(HttpConnection httpConnection) {
        this.connectionToAdded.remove(httpConnection);
    }

    public void removeAll() {
        this.connectionToAdded.clear();
    }

    public void closeIdleConnections(long l2) {
        long l3 = System.currentTimeMillis() - l2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking for connections, idleTimeout: " + l3);
        }
        Iterator iterator = this.connectionToAdded.keySet().iterator();
        while (iterator.hasNext()) {
            HttpConnection httpConnection = (HttpConnection)iterator.next();
            Long l4 = (Long)this.connectionToAdded.get(httpConnection);
            if (l4 > l3) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing connection, connection time: " + l4);
            }
            iterator.remove();
            httpConnection.close();
        }
    }
}

