/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ReflectionSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class SSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final SSLProtocolSocketFactory factory = new SSLProtocolSocketFactory();

    static SSLProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        return SSLSocketFactory.getDefault().createSocket(string, n2, inetAddress, n3);
    }

    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n4 = httpConnectionParams.getConnectionTimeout();
        if (n4 == 0) {
            return this.createSocket(string, n2, inetAddress, n3);
        }
        Socket socket = ReflectionSocketFactory.createSocket("javax.net.ssl.SSLSocketFactory", string, n2, inetAddress, n3, n4);
        if (socket == null) {
            socket = ControllerThreadSocketFactory.createSocket(this, string, n2, inetAddress, n3, n4);
        }
        return socket;
    }

    public Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        return SSLSocketFactory.getDefault().createSocket(string, n2);
    }

    public Socket createSocket(Socket socket, String string, int n2, boolean bl2) throws IOException, UnknownHostException {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(socket, string, n2, bl2);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

