/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.ConnectTimeoutException;

public final class ReflectionSocketFactory {
    private static boolean REFLECTION_FAILED = false;
    private static Constructor INETSOCKETADDRESS_CONSTRUCTOR = null;
    private static Method SOCKETCONNECT_METHOD = null;
    private static Method SOCKETBIND_METHOD = null;
    private static Class SOCKETTIMEOUTEXCEPTION_CLASS = null;

    private ReflectionSocketFactory() {
    }

    public static Socket createSocket(String string, String string2, int n2, InetAddress inetAddress, int n3, int n4) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (REFLECTION_FAILED) {
            return null;
        }
        try {
            Class<Object> clazz;
            Class<?> clazz2 = Class.forName(string);
            Method method = clazz2.getMethod("getDefault", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            method = clazz2.getMethod("createSocket", new Class[0]);
            Socket socket = (Socket)method.invoke(object, new Object[0]);
            if (INETSOCKETADDRESS_CONSTRUCTOR == null) {
                clazz = Class.forName("java.net.InetSocketAddress");
                INETSOCKETADDRESS_CONSTRUCTOR = clazz.getConstructor(InetAddress.class, Integer.TYPE);
            }
            clazz = INETSOCKETADDRESS_CONSTRUCTOR.newInstance(InetAddress.getByName(string2), new Integer(n2));
            Object t2 = INETSOCKETADDRESS_CONSTRUCTOR.newInstance(inetAddress, new Integer(n3));
            if (SOCKETCONNECT_METHOD == null) {
                SOCKETCONNECT_METHOD = Socket.class.getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
            }
            if (SOCKETBIND_METHOD == null) {
                SOCKETBIND_METHOD = Socket.class.getMethod("bind", Class.forName("java.net.SocketAddress"));
            }
            SOCKETBIND_METHOD.invoke((Object)socket, t2);
            SOCKETCONNECT_METHOD.invoke((Object)socket, clazz, new Integer(n4));
            return socket;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (SOCKETTIMEOUTEXCEPTION_CLASS == null) {
                try {
                    SOCKETTIMEOUTEXCEPTION_CLASS = Class.forName("java.net.SocketTimeoutException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    REFLECTION_FAILED = true;
                    return null;
                }
            }
            if (SOCKETTIMEOUTEXCEPTION_CLASS.isInstance(throwable)) {
                throw new ConnectTimeoutException("The host did not accept the connection within timeout of " + n4 + " ms", throwable);
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            return null;
        }
        catch (Exception exception) {
            REFLECTION_FAILED = true;
            return null;
        }
    }
}

