/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.ReflectionSocketFactory;

public class DefaultProtocolSocketFactory
implements ProtocolSocketFactory {
    private static final DefaultProtocolSocketFactory factory = new DefaultProtocolSocketFactory();

    static DefaultProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        return new Socket(string, n2, inetAddress, n3);
    }

    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n4 = httpConnectionParams.getConnectionTimeout();
        if (n4 == 0) {
            return this.createSocket(string, n2, inetAddress, n3);
        }
        Socket socket = ReflectionSocketFactory.createSocket("javax.net.SocketFactory", string, n2, inetAddress, n3, n4);
        if (socket == null) {
            socket = ControllerThreadSocketFactory.createSocket(this, string, n2, inetAddress, n3, n4);
        }
        return socket;
    }

    public Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        return new Socket(string, n2);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

