/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.params;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.params.HttpConnectionParams;

public class HttpConnectionManagerParams
extends HttpConnectionParams {
    public static final String MAX_HOST_CONNECTIONS = "http.connection-manager.max-per-host";
    public static final String MAX_TOTAL_CONNECTIONS = "http.connection-manager.max-total";

    public void setDefaultMaxConnectionsPerHost(int n2) {
        this.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, n2);
    }

    public void setMaxConnectionsPerHost(HostConfiguration hostConfiguration, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxHostConnections must be greater than 0");
        }
        Map map = (Map)this.getParameter(MAX_HOST_CONNECTIONS);
        HashMap<HostConfiguration, Integer> hashMap = null;
        hashMap = map == null ? new HashMap<HostConfiguration, Integer>() : new HashMap(map);
        hashMap.put(hostConfiguration, new Integer(n2));
        this.setParameter(MAX_HOST_CONNECTIONS, hashMap);
    }

    public int getDefaultMaxConnectionsPerHost() {
        return this.getMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION);
    }

    public int getMaxConnectionsPerHost(HostConfiguration hostConfiguration) {
        Map map = (Map)this.getParameter(MAX_HOST_CONNECTIONS);
        if (map == null) {
            return 2;
        }
        Integer n2 = (Integer)map.get(hostConfiguration);
        if (n2 == null && hostConfiguration != HostConfiguration.ANY_HOST_CONFIGURATION) {
            return this.getMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION);
        }
        return n2 == null ? 2 : n2;
    }

    public void setMaxTotalConnections(int n2) {
        this.setIntParameter(MAX_TOTAL_CONNECTIONS, n2);
    }

    public int getMaxTotalConnections() {
        return this.getIntParameter(MAX_TOTAL_CONNECTIONS, 20);
    }
}

