/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.Cookie2;
import org.apache.commons.httpclient.cookie.CookieAttributeHandler;
import org.apache.commons.httpclient.cookie.CookieOrigin;
import org.apache.commons.httpclient.cookie.CookiePathComparator;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.CookieVersionSupport;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.cookie.RFC2109Spec;
import org.apache.commons.httpclient.util.ParameterFormatter;

public class RFC2965Spec
extends CookieSpecBase
implements CookieVersionSupport {
    private static final Comparator PATH_COMPOARATOR = new CookiePathComparator();
    public static final String SET_COOKIE2_KEY = "set-cookie2";
    private final ParameterFormatter formatter = new ParameterFormatter();
    private final List attribHandlerList;
    private final Map attribHandlerMap;
    private final CookieSpec rfc2109;

    public RFC2965Spec() {
        this.formatter.setAlwaysUseQuotes(true);
        this.attribHandlerMap = new HashMap(10);
        this.attribHandlerList = new ArrayList(10);
        this.rfc2109 = new RFC2109Spec();
        this.registerAttribHandler("path", new Cookie2PathAttributeHandler());
        this.registerAttribHandler("domain", new Cookie2DomainAttributeHandler());
        this.registerAttribHandler("port", new Cookie2PortAttributeHandler());
        this.registerAttribHandler("max-age", new Cookie2MaxageAttributeHandler());
        this.registerAttribHandler("secure", new CookieSecureAttributeHandler());
        this.registerAttribHandler("comment", new CookieCommentAttributeHandler());
        this.registerAttribHandler("commenturl", new CookieCommentUrlAttributeHandler());
        this.registerAttribHandler("discard", new CookieDiscardAttributeHandler());
        this.registerAttribHandler("version", new Cookie2VersionAttributeHandler());
    }

    protected void registerAttribHandler(String string, CookieAttributeHandler cookieAttributeHandler) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute name may not be null");
        }
        if (cookieAttributeHandler == null) {
            throw new IllegalArgumentException("Attribute handler may not be null");
        }
        if (!this.attribHandlerList.contains(cookieAttributeHandler)) {
            this.attribHandlerList.add(cookieAttributeHandler);
        }
        this.attribHandlerMap.put(string, cookieAttributeHandler);
    }

    protected CookieAttributeHandler findAttribHandler(String string) {
        return (CookieAttributeHandler)this.attribHandlerMap.get(string);
    }

    protected CookieAttributeHandler getAttribHandler(String string) {
        CookieAttributeHandler cookieAttributeHandler = this.findAttribHandler(string);
        if (cookieAttributeHandler == null) {
            throw new IllegalStateException("Handler not registered for " + string + " attribute.");
        }
        return cookieAttributeHandler;
    }

    protected Iterator getAttribHandlerIterator() {
        return this.attribHandlerList.iterator();
    }

    public Cookie[] parse(String string, int n2, String string2, boolean bl2, Header header) throws MalformedCookieException {
        LOG.trace("enter RFC2965.parse(String, int, String, boolean, Header)");
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null.");
        }
        if (header.getName() == null) {
            throw new IllegalArgumentException("Header name may not be null.");
        }
        if (header.getName().equalsIgnoreCase(SET_COOKIE2_KEY)) {
            return this.parse(string, n2, string2, bl2, header.getValue());
        }
        if (header.getName().equalsIgnoreCase("set-cookie")) {
            return this.rfc2109.parse(string, n2, string2, bl2, header.getValue());
        }
        throw new MalformedCookieException("Header name is not valid. RFC 2965 supports \"set-cookie\" and \"set-cookie2\" headers.");
    }

    public Cookie[] parse(String string, int n2, String string2, boolean bl2, String string3) throws MalformedCookieException {
        LOG.trace("enter RFC2965Spec.parse(String, int, String, boolean, String)");
        if (string == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (string.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid port: " + n2);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Header may not be null.");
        }
        if (string2.trim().equals("")) {
            string2 = "/";
        }
        string = RFC2965Spec.getEffectiveHost(string);
        HeaderElement[] headerElementArray = HeaderElement.parseElements(string3.toCharArray());
        LinkedList<Cookie2> linkedList = new LinkedList<Cookie2>();
        for (int i2 = 0; i2 < headerElementArray.length; ++i2) {
            HeaderElement headerElement = headerElementArray[i2];
            Cookie2 cookie2 = null;
            try {
                cookie2 = new Cookie2(string, headerElement.getName(), headerElement.getValue(), string2, null, false, new int[]{n2});
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedCookieException(illegalArgumentException.getMessage());
            }
            NameValuePair[] nameValuePairArray = headerElement.getParameters();
            if (nameValuePairArray != null) {
                HashMap<String, NameValuePair> hashMap = new HashMap<String, NameValuePair>(nameValuePairArray.length);
                for (int i3 = nameValuePairArray.length - 1; i3 >= 0; --i3) {
                    NameValuePair nameValuePair = nameValuePairArray[i3];
                    hashMap.put(nameValuePair.getName().toLowerCase(), nameValuePair);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    this.parseAttribute((NameValuePair)entry.getValue(), cookie2);
                }
            }
            linkedList.add(cookie2);
        }
        return linkedList.toArray(new Cookie[linkedList.size()]);
    }

    public void parseAttribute(NameValuePair nameValuePair, Cookie cookie) throws MalformedCookieException {
        if (nameValuePair == null) {
            throw new IllegalArgumentException("Attribute may not be null.");
        }
        if (nameValuePair.getName() == null) {
            throw new IllegalArgumentException("Attribute Name may not be null.");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null.");
        }
        String string = nameValuePair.getName().toLowerCase();
        String string2 = nameValuePair.getValue();
        CookieAttributeHandler cookieAttributeHandler = this.findAttribHandler(string);
        if (cookieAttributeHandler == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unrecognized cookie attribute: " + nameValuePair.toString());
            }
        } else {
            cookieAttributeHandler.parse(cookie, string2);
        }
    }

    public void validate(String string, int n2, String string2, boolean bl2, Cookie cookie) throws MalformedCookieException {
        LOG.trace("enter RFC2965Spec.validate(String, int, String, boolean, Cookie)");
        if (cookie instanceof Cookie2) {
            if (cookie.getName().indexOf(32) != -1) {
                throw new MalformedCookieException("Cookie name may not contain blanks");
            }
            if (cookie.getName().startsWith("$")) {
                throw new MalformedCookieException("Cookie name may not start with $");
            }
            CookieOrigin cookieOrigin = new CookieOrigin(RFC2965Spec.getEffectiveHost(string), n2, string2, bl2);
            Iterator iterator = this.getAttribHandlerIterator();
            while (iterator.hasNext()) {
                CookieAttributeHandler cookieAttributeHandler = (CookieAttributeHandler)iterator.next();
                cookieAttributeHandler.validate(cookie, cookieOrigin);
            }
        } else {
            this.rfc2109.validate(string, n2, string2, bl2, cookie);
        }
    }

    public boolean match(String string, int n2, String string2, boolean bl2, Cookie cookie) {
        LOG.trace("enter RFC2965.match(String, int, String, boolean, Cookie");
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookie instanceof Cookie2) {
            if (cookie.isPersistent() && cookie.isExpired()) {
                return false;
            }
            CookieOrigin cookieOrigin = new CookieOrigin(RFC2965Spec.getEffectiveHost(string), n2, string2, bl2);
            Iterator iterator = this.getAttribHandlerIterator();
            while (iterator.hasNext()) {
                CookieAttributeHandler cookieAttributeHandler = (CookieAttributeHandler)iterator.next();
                if (cookieAttributeHandler.match(cookie, cookieOrigin)) continue;
                return false;
            }
            return true;
        }
        return this.rfc2109.match(string, n2, string2, bl2, cookie);
    }

    private void doFormatCookie2(Cookie2 cookie2, StringBuffer stringBuffer) {
        String string = cookie2.getName();
        String string2 = cookie2.getValue();
        if (string2 == null) {
            string2 = "";
        }
        this.formatter.format(stringBuffer, new NameValuePair(string, string2));
        if (cookie2.getDomain() != null && cookie2.isDomainAttributeSpecified()) {
            stringBuffer.append("; ");
            this.formatter.format(stringBuffer, new NameValuePair("$Domain", cookie2.getDomain()));
        }
        if (cookie2.getPath() != null && cookie2.isPathAttributeSpecified()) {
            stringBuffer.append("; ");
            this.formatter.format(stringBuffer, new NameValuePair("$Path", cookie2.getPath()));
        }
        if (cookie2.isPortAttributeSpecified()) {
            String string3 = "";
            if (!cookie2.isPortAttributeBlank()) {
                string3 = this.createPortAttribute(cookie2.getPorts());
            }
            stringBuffer.append("; ");
            this.formatter.format(stringBuffer, new NameValuePair("$Port", string3));
        }
    }

    public String formatCookie(Cookie cookie) {
        LOG.trace("enter RFC2965Spec.formatCookie(Cookie)");
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookie instanceof Cookie2) {
            Cookie2 cookie2 = (Cookie2)cookie;
            int n2 = cookie2.getVersion();
            StringBuffer stringBuffer = new StringBuffer();
            this.formatter.format(stringBuffer, new NameValuePair("$Version", Integer.toString(n2)));
            stringBuffer.append("; ");
            this.doFormatCookie2(cookie2, stringBuffer);
            return stringBuffer.toString();
        }
        return this.rfc2109.formatCookie(cookie);
    }

    public String formatCookies(Cookie[] cookieArray) {
        LOG.trace("enter RFC2965Spec.formatCookieHeader(Cookie[])");
        if (cookieArray == null) {
            throw new IllegalArgumentException("Cookies may not be null");
        }
        boolean bl2 = false;
        int n2 = -1;
        for (int i2 = 0; i2 < cookieArray.length; ++i2) {
            Cookie cookie = cookieArray[i2];
            if (!(cookie instanceof Cookie2)) {
                bl2 = true;
                break;
            }
            if (cookie.getVersion() <= n2) continue;
            n2 = cookie.getVersion();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (bl2 || n2 < 1) {
            return this.rfc2109.formatCookies(cookieArray);
        }
        Arrays.sort(cookieArray, PATH_COMPOARATOR);
        StringBuffer stringBuffer = new StringBuffer();
        this.formatter.format(stringBuffer, new NameValuePair("$Version", Integer.toString(n2)));
        for (int i3 = 0; i3 < cookieArray.length; ++i3) {
            stringBuffer.append("; ");
            Cookie2 cookie2 = (Cookie2)cookieArray[i3];
            this.doFormatCookie2(cookie2, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private String createPortAttribute(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray[i2]);
        }
        return stringBuffer.toString();
    }

    private int[] parsePortAttribute(String string) throws MalformedCookieException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        try {
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n2] = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (nArray[n2] < 0) {
                    throw new MalformedCookieException("Invalid Port attribute.");
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCookieException("Invalid Port attribute: " + numberFormatException.getMessage());
        }
        return nArray;
    }

    private static String getEffectiveHost(String string) {
        String string2 = string.toLowerCase();
        if (string.indexOf(46) < 0) {
            string2 = string2 + ".local";
        }
        return string2;
    }

    public boolean domainMatch(String string, String string2) {
        boolean bl2 = string.equals(string2) || string2.startsWith(".") && string.endsWith(string2);
        return bl2;
    }

    private boolean portMatch(int n2, int[] nArray) {
        boolean bl2 = false;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 != nArray[i2]) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public int getVersion() {
        return 1;
    }

    public Header getVersionHeader() {
        ParameterFormatter parameterFormatter = new ParameterFormatter();
        StringBuffer stringBuffer = new StringBuffer();
        parameterFormatter.format(stringBuffer, new NameValuePair("$Version", Integer.toString(this.getVersion())));
        return new Header("Cookie2", stringBuffer.toString(), true);
    }

    private class Cookie2VersionAttributeHandler
    implements CookieAttributeHandler {
        private Cookie2VersionAttributeHandler() {
        }

        public void parse(Cookie cookie, String string) throws MalformedCookieException {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (cookie instanceof Cookie2) {
                Cookie2 cookie2 = (Cookie2)cookie;
                if (string == null) {
                    throw new MalformedCookieException("Missing value for version attribute");
                }
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
                if (n2 < 0) {
                    throw new MalformedCookieException("Invalid cookie version.");
                }
                cookie2.setVersion(n2);
                cookie2.setVersionAttributeSpecified(true);
            }
        }

        public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
            Cookie2 cookie2;
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (cookie instanceof Cookie2 && !(cookie2 = (Cookie2)cookie).isVersionAttributeSpecified()) {
                throw new MalformedCookieException("Violates RFC 2965. Version attribute is required.");
            }
        }

        public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
            return true;
        }
    }

    private class CookieDiscardAttributeHandler
    implements CookieAttributeHandler {
        private CookieDiscardAttributeHandler() {
        }

        public void parse(Cookie cookie, String string) throws MalformedCookieException {
            if (cookie instanceof Cookie2) {
                Cookie2 cookie2 = (Cookie2)cookie;
                cookie2.setDiscard(true);
            }
        }

        public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        }

        public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
            return true;
        }
    }

    private class CookieCommentUrlAttributeHandler
    implements CookieAttributeHandler {
        private CookieCommentUrlAttributeHandler() {
        }

        public void parse(Cookie cookie, String string) throws MalformedCookieException {
            if (cookie instanceof Cookie2) {
                Cookie2 cookie2 = (Cookie2)cookie;
                cookie2.setCommentURL(string);
            }
        }

        public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        }

        public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
            return true;
        }
    }

    private class CookieCommentAttributeHandler
    implements CookieAttributeHandler {
        private CookieCommentAttributeHandler() {
        }

        public void parse(Cookie cookie, String string) throws MalformedCookieException {
            cookie.setComment(string);
        }

        public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        }

        public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
            return true;
        }
    }

    private class CookieSecureAttributeHandler
    implements CookieAttributeHandler {
        private CookieSecureAttributeHandler() {
        }

        public void parse(Cookie cookie, String string) throws MalformedCookieException {
            cookie.setSecure(true);
        }

        public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        }

        public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (cookieOrigin == null) {
                throw new IllegalArgumentException("Cookie origin may not be null");
            }
            return cookie.getSecure() == cookieOrigin.isSecure();
        }
    }

    private class Cookie2MaxageAttributeHandler
    implements CookieAttributeHandler {
        private Cookie2MaxageAttributeHandler() {
        }

        public void parse(Cookie cookie, String string) throws MalformedCookieException {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (string == null) {
                throw new MalformedCookieException("Missing value for max-age attribute");
            }
            int n2 = -1;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            if (n2 < 0) {
                throw new MalformedCookieException("Invalid max-age attribute.");
            }
            cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)n2 * 1000L));
        }

        public void validate(Cookie cookie, CookieOrigin cookieOrigin) {
        }

        public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
            return true;
        }
    }

    private class Cookie2PortAttributeHandler
    implements CookieAttributeHandler {
        private Cookie2PortAttributeHandler() {
        }

        public void parse(Cookie cookie, String string) throws MalformedCookieException {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (cookie instanceof Cookie2) {
                Cookie2 cookie2 = (Cookie2)cookie;
                if (string == null || string.trim().equals("")) {
                    cookie2.setPortAttributeBlank(true);
                } else {
                    int[] nArray = RFC2965Spec.this.parsePortAttribute(string);
                    cookie2.setPorts(nArray);
                }
                cookie2.setPortAttributeSpecified(true);
            }
        }

        public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (cookieOrigin == null) {
                throw new IllegalArgumentException("Cookie origin may not be null");
            }
            if (cookie instanceof Cookie2) {
                Cookie2 cookie2 = (Cookie2)cookie;
                int n2 = cookieOrigin.getPort();
                if (cookie2.isPortAttributeSpecified() && !RFC2965Spec.this.portMatch(n2, cookie2.getPorts())) {
                    throw new MalformedCookieException("Port attribute violates RFC 2965: Request port not found in cookie's port list.");
                }
            }
        }

        public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (cookieOrigin == null) {
                throw new IllegalArgumentException("Cookie origin may not be null");
            }
            if (cookie instanceof Cookie2) {
                Cookie2 cookie2 = (Cookie2)cookie;
                int n2 = cookieOrigin.getPort();
                if (cookie2.isPortAttributeSpecified()) {
                    if (cookie2.getPorts() == null) {
                        CookieSpecBase.LOG.warn("Invalid cookie state: port not specified");
                        return false;
                    }
                    if (!RFC2965Spec.this.portMatch(n2, cookie2.getPorts())) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }

    private class Cookie2DomainAttributeHandler
    implements CookieAttributeHandler {
        private Cookie2DomainAttributeHandler() {
        }

        public void parse(Cookie cookie, String string) throws MalformedCookieException {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (string == null) {
                throw new MalformedCookieException("Missing value for domain attribute");
            }
            if (string.trim().equals("")) {
                throw new MalformedCookieException("Blank value for domain attribute");
            }
            if (!(string = string.toLowerCase()).startsWith(".")) {
                string = "." + string;
            }
            cookie.setDomain(string);
            cookie.setDomainAttributeSpecified(true);
        }

        public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (cookieOrigin == null) {
                throw new IllegalArgumentException("Cookie origin may not be null");
            }
            String string = cookieOrigin.getHost().toLowerCase();
            if (cookie.getDomain() == null) {
                throw new MalformedCookieException("Invalid cookie state: domain not specified");
            }
            String string2 = cookie.getDomain().toLowerCase();
            if (cookie.isDomainAttributeSpecified()) {
                if (!string2.startsWith(".")) {
                    throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2109: domain must start with a dot");
                }
                int n2 = string2.indexOf(46, 1);
                if (!(n2 >= 0 && n2 != string2.length() - 1 || string2.equals(".local"))) {
                    throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2965: the value contains no embedded dots " + "and the value is not .local");
                }
                if (!RFC2965Spec.this.domainMatch(string, string2)) {
                    throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2965: effective host name does not " + "domain-match domain attribute.");
                }
                String string3 = string.substring(0, string.length() - string2.length());
                if (string3.indexOf(46) != -1) {
                    throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2965: " + "effective host minus domain may not contain any dots");
                }
            } else if (!cookie.getDomain().equals(string)) {
                throw new MalformedCookieException("Illegal domain attribute: \"" + cookie.getDomain() + "\"." + "Domain of origin: \"" + string + "\"");
            }
        }

        public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
            String string;
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (cookieOrigin == null) {
                throw new IllegalArgumentException("Cookie origin may not be null");
            }
            String string2 = cookieOrigin.getHost().toLowerCase();
            if (!RFC2965Spec.this.domainMatch(string2, string = cookie.getDomain())) {
                return false;
            }
            String string3 = string2.substring(0, string2.length() - string.length());
            return string3.indexOf(46) == -1;
        }
    }

    private class Cookie2PathAttributeHandler
    implements CookieAttributeHandler {
        private Cookie2PathAttributeHandler() {
        }

        public void parse(Cookie cookie, String string) throws MalformedCookieException {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (string == null) {
                throw new MalformedCookieException("Missing value for path attribute");
            }
            if (string.trim().equals("")) {
                throw new MalformedCookieException("Blank value for path attribute");
            }
            cookie.setPath(string);
            cookie.setPathAttributeSpecified(true);
        }

        public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (cookieOrigin == null) {
                throw new IllegalArgumentException("Cookie origin may not be null");
            }
            String string = cookieOrigin.getPath();
            if (string == null) {
                throw new IllegalArgumentException("Path of origin host may not be null.");
            }
            if (cookie.getPath() == null) {
                throw new MalformedCookieException("Invalid cookie state: path attribute is null.");
            }
            if (string.trim().equals("")) {
                string = "/";
            }
            if (!RFC2965Spec.this.pathMatch(string, cookie.getPath())) {
                throw new MalformedCookieException("Illegal path attribute \"" + cookie.getPath() + "\". Path of origin: \"" + string + "\"");
            }
        }

        public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (cookieOrigin == null) {
                throw new IllegalArgumentException("Cookie origin may not be null");
            }
            String string = cookieOrigin.getPath();
            if (cookie.getPath() == null) {
                CookieSpecBase.LOG.warn("Invalid cookie state: path attribute is null.");
                return false;
            }
            if (string.trim().equals("")) {
                string = "/";
            }
            return RFC2965Spec.this.pathMatch(string, cookie.getPath());
        }
    }
}

