/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.utils;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class HttpMethodCloner {
    private static void copyEntityEnclosingMethod(EntityEnclosingMethod entityEnclosingMethod, EntityEnclosingMethod entityEnclosingMethod2) throws IOException {
        entityEnclosingMethod2.setRequestEntity(entityEnclosingMethod.getRequestEntity());
    }

    private static void copyHttpMethodBase(HttpMethodBase httpMethodBase, HttpMethodBase httpMethodBase2) {
        try {
            httpMethodBase2.setParams((HttpMethodParams)httpMethodBase.getParams().clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public static HttpMethod clone(HttpMethod httpMethod) throws IOException {
        HttpMethod httpMethod2 = null;
        try {
            httpMethod2 = (HttpMethod)httpMethod.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (httpMethod2 == null) {
            return null;
        }
        httpMethod2.setDoAuthentication(httpMethod.getDoAuthentication());
        httpMethod2.setFollowRedirects(httpMethod.getFollowRedirects());
        httpMethod2.setPath(httpMethod.getPath());
        httpMethod2.setQueryString(httpMethod.getQueryString());
        Header[] headerArray = httpMethod.getRequestHeaders();
        int n2 = headerArray == null ? 0 : headerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            httpMethod2.setRequestHeader(new Header(headerArray[i2].getName(), headerArray[i2].getValue()));
        }
        httpMethod2.setStrictMode(httpMethod.isStrictMode());
        if (httpMethod instanceof HttpMethodBase) {
            HttpMethodCloner.copyHttpMethodBase((HttpMethodBase)httpMethod, (HttpMethodBase)httpMethod2);
        }
        if (httpMethod instanceof EntityEnclosingMethod) {
            HttpMethodCloner.copyEntityEnclosingMethod((EntityEnclosingMethod)httpMethod, (EntityEnclosingMethod)httpMethod2);
        }
        return httpMethod2;
    }
}

