/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StrictSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(StrictSSLProtocolSocketFactory.class);
    private boolean verifyHostname = true;

    public StrictSSLProtocolSocketFactory(boolean bl2) {
        this.verifyHostname = bl2;
    }

    public StrictSSLProtocolSocketFactory() {
    }

    public void setHostnameVerification(boolean bl2) {
        this.verifyHostname = bl2;
    }

    public boolean getHostnameVerification() {
        return this.verifyHostname;
    }

    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n2, inetAddress, n3);
        this.verifyHostname(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n4 = httpConnectionParams.getConnectionTimeout();
        Socket socket = null;
        SocketFactory socketFactory = SSLSocketFactory.getDefault();
        if (n4 == 0) {
            socket = socketFactory.createSocket(string, n2, inetAddress, n3);
        } else {
            socket = socketFactory.createSocket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n3);
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n2);
            socket.bind(inetSocketAddress);
            socket.connect(inetSocketAddress2, n4);
        }
        this.verifyHostname((SSLSocket)socket);
        return socket;
    }

    public Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n2);
        this.verifyHostname(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(Socket socket, String string, int n2, boolean bl2) throws IOException, UnknownHostException {
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n2, bl2);
        this.verifyHostname(sSLSocket);
        return sSLSocket;
    }

    private void verifyHostname(SSLSocket sSLSocket) throws SSLPeerUnverifiedException, UnknownHostException {
        String string;
        X509Certificate[] x509CertificateArray;
        if (!this.verifyHostname) {
            return;
        }
        SSLSession sSLSession = sSLSocket.getSession();
        String string2 = sSLSession.getPeerHost();
        try {
            x509CertificateArray = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new UnknownHostException("Could not resolve SSL sessions server hostname: " + string2);
        }
        x509CertificateArray = sSLSession.getPeerCertificateChain();
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new SSLPeerUnverifiedException("No server certificates found!");
        }
        String string3 = x509CertificateArray[0].getSubjectDN().getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Server certificate chain:");
            for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                LOG.debug("X509Certificate[" + i2 + "]=" + x509CertificateArray[i2]);
            }
        }
        if (string2.equalsIgnoreCase(string = this.getCN(string3))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Target hostname valid: " + string);
            }
        } else {
            throw new SSLPeerUnverifiedException("HTTPS hostname invalid: expected '" + string2 + "', received '" + string + "'");
        }
    }

    private String getCN(String string) {
        int n2 = 0;
        n2 = string.indexOf("CN=");
        if (n2 == -1) {
            return null;
        }
        string = string.substring(n2 + 3);
        char[] cArray = string.toCharArray();
        for (n2 = 0; n2 < cArray.length && (cArray[n2] != ',' || n2 <= 0 || cArray[n2 - 1] == '\\'); ++n2) {
        }
        return string.substring(0, n2);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(StrictSSLProtocolSocketFactory.class)) {
            return ((StrictSSLProtocolSocketFactory)object).getHostnameVerification() == this.verifyHostname;
        }
        return false;
    }

    public int hashCode() {
        return StrictSSLProtocolSocketFactory.class.hashCode();
    }
}

