/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.contrib.ssl.EasyX509TrustManager;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EasySSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(EasySSLProtocolSocketFactory.class);
    private SSLContext sslcontext = null;

    private static SSLContext createEasySSLContext() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, new TrustManager[]{new EasyX509TrustManager(null)}, null);
            return sSLContext;
        }
        catch (Exception exception) {
            LOG.error(exception.getMessage(), exception);
            throw new HttpClientError(exception.toString());
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = EasySSLProtocolSocketFactory.createEasySSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n2, inetAddress, n3);
    }

    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n4 = httpConnectionParams.getConnectionTimeout();
        SSLSocketFactory sSLSocketFactory = this.getSSLContext().getSocketFactory();
        if (n4 == 0) {
            return sSLSocketFactory.createSocket(string, n2, inetAddress, n3);
        }
        Socket socket = sSLSocketFactory.createSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n3);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n2);
        socket.bind(inetSocketAddress);
        socket.connect(inetSocketAddress2, n4);
        return socket;
    }

    public Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n2);
    }

    public Socket createSocket(Socket socket, String string, int n2, boolean bl2) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, string, n2, bl2);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(EasySSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return EasySSLProtocolSocketFactory.class.hashCode();
    }
}

