/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.httpclient.util.ParameterFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigestScheme
extends RFC2617Scheme {
    private static final Log LOG = LogFactory.getLog(DigestScheme.class);
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private boolean complete = false;
    private static final String NC = "00000001";
    private static final int QOP_MISSING = 0;
    private static final int QOP_AUTH_INT = 1;
    private static final int QOP_AUTH = 2;
    private int qopVariant = 0;
    private String cnonce;
    private final ParameterFormatter formatter = new ParameterFormatter();

    public DigestScheme() {
    }

    public String getID() {
        String string = this.getRealm();
        String string2 = this.getParameter("nonce");
        if (string2 != null) {
            string = string + "-" + string2;
        }
        return string;
    }

    public DigestScheme(String string) throws MalformedChallengeException {
        this();
        this.processChallenge(string);
    }

    public void processChallenge(String string) throws MalformedChallengeException {
        super.processChallenge(string);
        if (this.getParameter("realm") == null) {
            throw new MalformedChallengeException("missing realm in challange");
        }
        if (this.getParameter("nonce") == null) {
            throw new MalformedChallengeException("missing nonce in challange");
        }
        boolean bl2 = false;
        String string2 = this.getParameter("qop");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                if (string3.equals("auth")) {
                    this.qopVariant = 2;
                    break;
                }
                if (string3.equals("auth-int")) {
                    this.qopVariant = 1;
                    continue;
                }
                bl2 = true;
                LOG.warn("Unsupported qop detected: " + string3);
            }
        }
        if (bl2 && this.qopVariant == 0) {
            throw new MalformedChallengeException("None of the qop methods is supported");
        }
        this.cnonce = DigestScheme.createCnonce();
        this.complete = true;
    }

    public boolean isComplete() {
        String string = this.getParameter("stale");
        if ("true".equalsIgnoreCase(string)) {
            return false;
        }
        return this.complete;
    }

    public String getSchemeName() {
        return "digest";
    }

    public boolean isConnectionBased() {
        return false;
    }

    public String authenticate(Credentials credentials, String string, String string2) throws AuthenticationException {
        LOG.trace("enter DigestScheme.authenticate(Credentials, String, String)");
        UsernamePasswordCredentials usernamePasswordCredentials = null;
        try {
            usernamePasswordCredentials = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidCredentialsException("Credentials cannot be used for digest authentication: " + credentials.getClass().getName());
        }
        this.getParameters().put("methodname", string);
        this.getParameters().put("uri", string2);
        String string3 = this.createDigest(usernamePasswordCredentials.getUserName(), usernamePasswordCredentials.getPassword());
        return "Digest " + this.createDigestHeader(usernamePasswordCredentials.getUserName(), string3);
    }

    public String authenticate(Credentials credentials, HttpMethod httpMethod) throws AuthenticationException {
        LOG.trace("enter DigestScheme.authenticate(Credentials, HttpMethod)");
        UsernamePasswordCredentials usernamePasswordCredentials = null;
        try {
            usernamePasswordCredentials = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidCredentialsException("Credentials cannot be used for digest authentication: " + credentials.getClass().getName());
        }
        this.getParameters().put("methodname", httpMethod.getName());
        StringBuffer stringBuffer = new StringBuffer(httpMethod.getPath());
        String string = httpMethod.getQueryString();
        if (string != null) {
            if (string.indexOf("?") != 0) {
                stringBuffer.append("?");
            }
            stringBuffer.append(httpMethod.getQueryString());
        }
        this.getParameters().put("uri", stringBuffer.toString());
        String string2 = this.getParameter("charset");
        if (string2 == null) {
            this.getParameters().put("charset", httpMethod.getParams().getCredentialCharset());
        }
        String string3 = this.createDigest(usernamePasswordCredentials.getUserName(), usernamePasswordCredentials.getPassword());
        return "Digest " + this.createDigestHeader(usernamePasswordCredentials.getUserName(), string3);
    }

    private String createDigest(String string, String string2) throws AuthenticationException {
        String string3;
        CharSequence charSequence;
        CharSequence charSequence2;
        String string4;
        MessageDigest messageDigest;
        String string5;
        LOG.trace("enter DigestScheme.createDigest(String, String, Map)");
        String string6 = this.getParameter("uri");
        String string7 = this.getParameter("realm");
        String string8 = this.getParameter("nonce");
        String string9 = this.getParameter("qop");
        String string10 = this.getParameter("methodname");
        String string11 = this.getParameter("algorithm");
        if (string11 == null) {
            string11 = "MD5";
        }
        if ((string5 = this.getParameter("charset")) == null) {
            string5 = "ISO-8859-1";
        }
        if (this.qopVariant == 1) {
            LOG.warn("qop=auth-int is not supported");
            throw new AuthenticationException("Unsupported qop in HTTP Digest authentication");
        }
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new AuthenticationException("Unsupported algorithm in HTTP Digest authentication: MD5");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + string7.length() + string2.length() + 2);
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string7);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        String string12 = stringBuffer.toString();
        if (string11.equals("MD5-sess")) {
            string4 = DigestScheme.encode(messageDigest.digest(EncodingUtil.getBytes(string12, string5)));
            charSequence2 = new StringBuffer(string4.length() + string8.length() + this.cnonce.length() + 2);
            ((StringBuffer)charSequence2).append(string4);
            ((StringBuffer)charSequence2).append(':');
            ((StringBuffer)charSequence2).append(string8);
            ((StringBuffer)charSequence2).append(':');
            ((StringBuffer)charSequence2).append(this.cnonce);
            string12 = ((StringBuffer)charSequence2).toString();
        } else if (!string11.equals("MD5")) {
            LOG.warn("Unhandled algorithm " + string11 + " requested");
        }
        string4 = DigestScheme.encode(messageDigest.digest(EncodingUtil.getBytes(string12, string5)));
        charSequence2 = null;
        if (this.qopVariant == 1) {
            LOG.error("Unhandled qop auth-int");
        } else {
            charSequence2 = string10 + ":" + string6;
        }
        String string13 = DigestScheme.encode(messageDigest.digest(EncodingUtil.getAsciiBytes((String)charSequence2)));
        if (this.qopVariant == 0) {
            LOG.debug("Using null qop method");
            charSequence = new StringBuffer(string4.length() + string8.length() + string13.length());
            ((StringBuffer)charSequence).append(string4);
            ((StringBuffer)charSequence).append(':');
            ((StringBuffer)charSequence).append(string8);
            ((StringBuffer)charSequence).append(':');
            ((StringBuffer)charSequence).append(string13);
            string3 = ((StringBuffer)charSequence).toString();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using qop method " + string9);
            }
            charSequence = this.getQopVariantString();
            StringBuffer stringBuffer2 = new StringBuffer(string4.length() + string8.length() + NC.length() + this.cnonce.length() + ((String)charSequence).length() + string13.length() + 5);
            stringBuffer2.append(string4);
            stringBuffer2.append(':');
            stringBuffer2.append(string8);
            stringBuffer2.append(':');
            stringBuffer2.append(NC);
            stringBuffer2.append(':');
            stringBuffer2.append(this.cnonce);
            stringBuffer2.append(':');
            stringBuffer2.append((String)charSequence);
            stringBuffer2.append(':');
            stringBuffer2.append(string13);
            string3 = stringBuffer2.toString();
        }
        charSequence = DigestScheme.encode(messageDigest.digest(EncodingUtil.getAsciiBytes(string3)));
        return charSequence;
    }

    private String createDigestHeader(String string, String string2) throws AuthenticationException {
        LOG.trace("enter DigestScheme.createDigestHeader(String, Map, String)");
        String string3 = this.getParameter("uri");
        String string4 = this.getParameter("realm");
        String string5 = this.getParameter("nonce");
        String string6 = this.getParameter("opaque");
        String string7 = string2;
        String string8 = this.getParameter("algorithm");
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>(20);
        arrayList.add(new NameValuePair("username", string));
        arrayList.add(new NameValuePair("realm", string4));
        arrayList.add(new NameValuePair("nonce", string5));
        arrayList.add(new NameValuePair("uri", string3));
        arrayList.add(new NameValuePair("response", string7));
        if (this.qopVariant != 0) {
            arrayList.add(new NameValuePair("qop", this.getQopVariantString()));
            arrayList.add(new NameValuePair("nc", NC));
            arrayList.add(new NameValuePair("cnonce", this.cnonce));
        }
        if (string8 != null) {
            arrayList.add(new NameValuePair("algorithm", string8));
        }
        if (string6 != null) {
            arrayList.add(new NameValuePair("opaque", string6));
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            NameValuePair nameValuePair = (NameValuePair)arrayList.get(i2);
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            boolean bl2 = "nc".equals(nameValuePair.getName()) || "qop".equals(nameValuePair.getName());
            this.formatter.setAlwaysUseQuotes(!bl2);
            this.formatter.format(stringBuffer, nameValuePair);
        }
        return stringBuffer.toString();
    }

    private String getQopVariantString() {
        String string = this.qopVariant == 1 ? "auth-int" : "auth";
        return string;
    }

    private static String encode(byte[] byArray) {
        LOG.trace("enter DigestScheme.encode(byte[])");
        if (byArray.length != 16) {
            return null;
        }
        char[] cArray = new char[32];
        for (int i2 = 0; i2 < 16; ++i2) {
            int n2 = byArray[i2] & 0xF;
            int n3 = (byArray[i2] & 0xF0) >> 4;
            cArray[i2 * 2] = HEXADECIMAL[n3];
            cArray[i2 * 2 + 1] = HEXADECIMAL[n2];
        }
        return new String(cArray);
    }

    public static String createCnonce() {
        MessageDigest messageDigest;
        LOG.trace("enter DigestScheme.createCnonce()");
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new HttpClientError("Unsupported algorithm in HTTP Digest authentication: MD5");
        }
        String string = Long.toString(System.currentTimeMillis());
        string = DigestScheme.encode(messageDigest.digest(EncodingUtil.getAsciiBytes(string)));
        return string;
    }
}

