/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import org.apache.commons.httpclient.util.LangUtils;

public class AuthScope {
    public static final String ANY_HOST = null;
    public static final int ANY_PORT = -1;
    public static final String ANY_REALM = null;
    public static final String ANY_SCHEME = null;
    public static final AuthScope ANY = new AuthScope(ANY_HOST, -1, ANY_REALM, ANY_SCHEME);
    private String scheme = null;
    private String realm = null;
    private String host = null;
    private int port = -1;

    public AuthScope(String string, int n2, String string2, String string3) {
        this.host = string == null ? ANY_HOST : string.toLowerCase();
        this.port = n2 < 0 ? -1 : n2;
        this.realm = string2 == null ? ANY_REALM : string2;
        this.scheme = string3 == null ? ANY_SCHEME : string3.toUpperCase();
    }

    public AuthScope(String string, int n2, String string2) {
        this(string, n2, string2, ANY_SCHEME);
    }

    public AuthScope(String string, int n2) {
        this(string, n2, ANY_REALM, ANY_SCHEME);
    }

    public AuthScope(AuthScope authScope) {
        if (authScope == null) {
            throw new IllegalArgumentException("Scope may not be null");
        }
        this.host = authScope.getHost();
        this.port = authScope.getPort();
        this.realm = authScope.getRealm();
        this.scheme = authScope.getScheme();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getScheme() {
        return this.scheme;
    }

    private static boolean paramsEqual(String string, String string2) {
        if (string == null) {
            return string == string2;
        }
        return string.equals(string2);
    }

    private static boolean paramsEqual(int n2, int n3) {
        return n2 == n3;
    }

    public int match(AuthScope authScope) {
        int n2 = 0;
        if (AuthScope.paramsEqual(this.scheme, authScope.scheme)) {
            ++n2;
        } else if (this.scheme != ANY_SCHEME && authScope.scheme != ANY_SCHEME) {
            return -1;
        }
        if (AuthScope.paramsEqual(this.realm, authScope.realm)) {
            n2 += 2;
        } else if (this.realm != ANY_REALM && authScope.realm != ANY_REALM) {
            return -1;
        }
        if (AuthScope.paramsEqual(this.port, authScope.port)) {
            n2 += 4;
        } else if (this.port != -1 && authScope.port != -1) {
            return -1;
        }
        if (AuthScope.paramsEqual(this.host, authScope.host)) {
            n2 += 8;
        } else if (this.host != ANY_HOST && authScope.host != ANY_HOST) {
            return -1;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof AuthScope)) {
            return super.equals(object);
        }
        AuthScope authScope = (AuthScope)object;
        return AuthScope.paramsEqual(this.host, authScope.host) && AuthScope.paramsEqual(this.port, authScope.port) && AuthScope.paramsEqual(this.realm, authScope.realm) && AuthScope.paramsEqual(this.scheme, authScope.scheme);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme != null) {
            stringBuffer.append(this.scheme.toUpperCase());
            stringBuffer.append(' ');
        }
        if (this.realm != null) {
            stringBuffer.append('\'');
            stringBuffer.append(this.realm);
            stringBuffer.append('\'');
        } else {
            stringBuffer.append("<any realm>");
        }
        if (this.host != null) {
            stringBuffer.append('@');
            stringBuffer.append(this.host);
            if (this.port >= 0) {
                stringBuffer.append(':');
                stringBuffer.append(this.port);
            }
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n2 = 17;
        n2 = LangUtils.hashCode(n2, this.host);
        n2 = LangUtils.hashCode(n2, this.port);
        n2 = LangUtils.hashCode(n2, this.realm);
        n2 = LangUtils.hashCode(n2, this.scheme);
        return n2;
    }
}

