/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.util.ParameterParser;

public final class AuthChallengeParser {
    public static String extractScheme(String string) throws MalformedChallengeException {
        if (string == null) {
            throw new IllegalArgumentException("Challenge may not be null");
        }
        int n2 = string.indexOf(32);
        String string2 = null;
        string2 = n2 == -1 ? string : string.substring(0, n2);
        if (string2.equals("")) {
            throw new MalformedChallengeException("Invalid challenge: " + string);
        }
        return string2.toLowerCase();
    }

    public static Map extractParams(String string) throws MalformedChallengeException {
        if (string == null) {
            throw new IllegalArgumentException("Challenge may not be null");
        }
        int n2 = string.indexOf(32);
        if (n2 == -1) {
            throw new MalformedChallengeException("Invalid challenge: " + string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ParameterParser parameterParser = new ParameterParser();
        List list = parameterParser.parse(string.substring(n2 + 1, string.length()), ',');
        for (int i2 = 0; i2 < list.size(); ++i2) {
            NameValuePair nameValuePair = (NameValuePair)list.get(i2);
            hashMap.put(nameValuePair.getName().toLowerCase(), nameValuePair.getValue());
        }
        return hashMap;
    }

    public static Map parseChallenges(Header[] headerArray) throws MalformedChallengeException {
        if (headerArray == null) {
            throw new IllegalArgumentException("Array of challenges may not be null");
        }
        String string = null;
        HashMap<String, String> hashMap = new HashMap<String, String>(headerArray.length);
        for (int i2 = 0; i2 < headerArray.length; ++i2) {
            string = headerArray[i2].getValue();
            String string2 = AuthChallengeParser.extractScheme(string);
            hashMap.put(string2, string);
        }
        return hashMap;
    }
}

