/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Wire {
    public static Wire HEADER_WIRE = new Wire(LogFactory.getLog("httpclient.wire.header"));
    public static Wire CONTENT_WIRE = new Wire(LogFactory.getLog("httpclient.wire.content"));
    private Log log;

    private Wire(Log log) {
        this.log = log;
    }

    private void wire(String string, InputStream inputStream) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = inputStream.read()) != -1) {
            if (n2 == 13) {
                stringBuffer.append("[\\r]");
                continue;
            }
            if (n2 == 10) {
                stringBuffer.append("[\\n]\"");
                stringBuffer.insert(0, "\"");
                stringBuffer.insert(0, string);
                this.log.debug(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            if (n2 < 32 || n2 > 127) {
                stringBuffer.append("[0x");
                stringBuffer.append(Integer.toHexString(n2));
                stringBuffer.append("]");
                continue;
            }
            stringBuffer.append((char)n2);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append("\"");
            stringBuffer.insert(0, "\"");
            stringBuffer.insert(0, string);
            this.log.debug(stringBuffer.toString());
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    public void output(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.wire(">> ", inputStream);
    }

    public void input(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.wire("<< ", inputStream);
    }

    public void output(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.wire(">> ", new ByteArrayInputStream(byArray, n2, n3));
    }

    public void input(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.wire("<< ", new ByteArrayInputStream(byArray, n2, n3));
    }

    public void output(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.wire(">> ", new ByteArrayInputStream(byArray));
    }

    public void input(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.wire("<< ", new ByteArrayInputStream(byArray));
    }

    public void output(int n2) throws IOException {
        this.output(new byte[]{(byte)n2});
    }

    public void input(int n2) throws IOException {
        this.input(new byte[]{(byte)n2});
    }

    public void output(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.output(string.getBytes());
    }

    public void input(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.input(string.getBytes());
    }
}

