/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.ProtocolException;

public class StatusLine {
    private final String statusLine;
    private final String httpVersion;
    private final int statusCode;
    private final String reasonPhrase;

    public StatusLine(String string) throws HttpException {
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        try {
            while (Character.isWhitespace(string.charAt(n3))) {
                ++n3;
                ++n4;
            }
            if (!"HTTP".equals(string.substring(n3, n3 += 4))) {
                throw new HttpException("Status-Line '" + string + "' does not start with HTTP");
            }
            if ((n3 = string.indexOf(" ", n3)) <= 0) {
                throw new ProtocolException("Unable to parse HTTP-Version from the status line: '" + string + "'");
            }
            this.httpVersion = string.substring(n4, n3).toUpperCase();
            while (string.charAt(n3) == ' ') {
                ++n3;
            }
            int n5 = string.indexOf(" ", n3);
            if (n5 < 0) {
                n5 = n2;
            }
            try {
                this.statusCode = Integer.parseInt(string.substring(n3, n5));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException("Unable to parse status code from status line: '" + string + "'");
            }
            n3 = n5 + 1;
            this.reasonPhrase = n3 < n2 ? string.substring(n3).trim() : "";
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new HttpException("Status-Line '" + string + "' is not valid");
        }
        this.statusLine = string;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getHttpVersion() {
        return this.httpVersion;
    }

    public final String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public final String toString() {
        return this.statusLine;
    }

    public static boolean startsWithHTTP(String string) {
        try {
            int n2 = 0;
            while (Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            return "HTTP".equals(string.substring(n2, n2 + 4));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
    }
}

