/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.httpclient.ConnectionPoolTimeoutException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.IdleConnectionHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiThreadedHttpConnectionManager
implements HttpConnectionManager {
    private static final Log LOG = LogFactory.getLog(MultiThreadedHttpConnectionManager.class);
    public static final int DEFAULT_MAX_HOST_CONNECTIONS = 2;
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 20;
    private static final Map REFERENCE_TO_CONNECTION_SOURCE = new HashMap();
    private static final ReferenceQueue REFERENCE_QUEUE = new ReferenceQueue();
    private static ReferenceQueueThread REFERENCE_QUEUE_THREAD;
    private static WeakHashMap ALL_CONNECTION_MANAGERS;
    private HttpConnectionManagerParams params = new HttpConnectionManagerParams();
    private ConnectionPool connectionPool = new ConnectionPool();
    private volatile boolean shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAll() {
        Map map = REFERENCE_TO_CONNECTION_SOURCE;
        synchronized (map) {
            WeakHashMap weakHashMap = ALL_CONNECTION_MANAGERS;
            synchronized (weakHashMap) {
                MultiThreadedHttpConnectionManager[] multiThreadedHttpConnectionManagerArray = ALL_CONNECTION_MANAGERS.keySet().toArray(new MultiThreadedHttpConnectionManager[ALL_CONNECTION_MANAGERS.size()]);
                for (int i2 = 0; i2 < multiThreadedHttpConnectionManagerArray.length; ++i2) {
                    if (multiThreadedHttpConnectionManagerArray[i2] == null) continue;
                    multiThreadedHttpConnectionManagerArray[i2].shutdown();
                }
            }
            if (REFERENCE_QUEUE_THREAD != null) {
                REFERENCE_QUEUE_THREAD.shutdown();
                REFERENCE_QUEUE_THREAD = null;
            }
            REFERENCE_TO_CONNECTION_SOURCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeReferenceToConnection(HttpConnectionWithReference httpConnectionWithReference, HostConfiguration hostConfiguration, ConnectionPool connectionPool) {
        ConnectionSource connectionSource = new ConnectionSource();
        connectionSource.connectionPool = connectionPool;
        connectionSource.hostConfiguration = hostConfiguration;
        Map map = REFERENCE_TO_CONNECTION_SOURCE;
        synchronized (map) {
            if (REFERENCE_QUEUE_THREAD == null) {
                REFERENCE_QUEUE_THREAD = new ReferenceQueueThread();
                REFERENCE_QUEUE_THREAD.start();
            }
            REFERENCE_TO_CONNECTION_SOURCE.put(httpConnectionWithReference.reference, connectionSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownCheckedOutConnections(ConnectionPool connectionPool) {
        ArrayList<HttpConnection> arrayList = new ArrayList<HttpConnection>();
        Map map = REFERENCE_TO_CONNECTION_SOURCE;
        synchronized (map) {
            Iterator object = REFERENCE_TO_CONNECTION_SOURCE.keySet().iterator();
            while (object.hasNext()) {
                Reference reference = (Reference)object.next();
                ConnectionSource connectionSource = (ConnectionSource)REFERENCE_TO_CONNECTION_SOURCE.get(reference);
                if (connectionSource.connectionPool != connectionPool) continue;
                object.remove();
                HttpConnection httpConnection = (HttpConnection)reference.get();
                if (httpConnection == null) continue;
                arrayList.add(httpConnection);
            }
        }
        for (HttpConnection httpConnection : arrayList) {
            httpConnection.close();
            httpConnection.setHttpConnectionManager(null);
            httpConnection.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeReferenceToConnection(HttpConnectionWithReference httpConnectionWithReference) {
        Map map = REFERENCE_TO_CONNECTION_SOURCE;
        synchronized (map) {
            REFERENCE_TO_CONNECTION_SOURCE.remove(httpConnectionWithReference.reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiThreadedHttpConnectionManager() {
        WeakHashMap weakHashMap = ALL_CONNECTION_MANAGERS;
        synchronized (weakHashMap) {
            ALL_CONNECTION_MANAGERS.put(this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (!this.shutdown) {
                this.shutdown = true;
                this.connectionPool.shutdown();
            }
        }
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.params.isStaleCheckingEnabled();
    }

    public void setConnectionStaleCheckingEnabled(boolean bl2) {
        this.params.setStaleCheckingEnabled(bl2);
    }

    public void setMaxConnectionsPerHost(int n2) {
        this.params.setDefaultMaxConnectionsPerHost(n2);
    }

    public int getMaxConnectionsPerHost() {
        return this.params.getDefaultMaxConnectionsPerHost();
    }

    public void setMaxTotalConnections(int n2) {
        this.params.setMaxTotalConnections(n2);
    }

    public int getMaxTotalConnections() {
        return this.params.getMaxTotalConnections();
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) {
        while (true) {
            try {
                return this.getConnectionWithTimeout(hostConfiguration, 0L);
            }
            catch (ConnectionPoolTimeoutException connectionPoolTimeoutException) {
                LOG.debug("Unexpected exception while waiting for connection", connectionPoolTimeoutException);
                continue;
            }
            break;
        }
    }

    public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long l2) throws ConnectionPoolTimeoutException {
        LOG.trace("enter HttpConnectionManager.getConnectionWithTimeout(HostConfiguration, long)");
        if (hostConfiguration == null) {
            throw new IllegalArgumentException("hostConfiguration is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HttpConnectionManager.getConnection:  config = " + hostConfiguration + ", timeout = " + l2);
        }
        HttpConnection httpConnection = this.doGetConnection(hostConfiguration, l2);
        return new HttpConnectionAdapter(httpConnection);
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long l2) throws HttpException {
        LOG.trace("enter HttpConnectionManager.getConnection(HostConfiguration, long)");
        try {
            return this.getConnectionWithTimeout(hostConfiguration, l2);
        }
        catch (ConnectionPoolTimeoutException connectionPoolTimeoutException) {
            throw new HttpException(connectionPoolTimeoutException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpConnection doGetConnection(HostConfiguration hostConfiguration, long l2) throws ConnectionPoolTimeoutException {
        HttpConnection httpConnection = null;
        int n2 = this.params.getMaxConnectionsPerHost(hostConfiguration);
        int n3 = this.params.getMaxTotalConnections();
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            hostConfiguration = new HostConfiguration(hostConfiguration);
            HostConnectionPool hostConnectionPool = this.connectionPool.getHostPool(hostConfiguration);
            WaitingThread waitingThread = null;
            boolean bl2 = l2 > 0L;
            long l3 = l2;
            long l4 = 0L;
            long l5 = 0L;
            while (httpConnection == null) {
                block20: {
                    if (this.shutdown) {
                        throw new IllegalStateException("Connection factory has been shutdown.");
                    }
                    if (hostConnectionPool.freeConnections.size() > 0) {
                        httpConnection = this.connectionPool.getFreeConnection(hostConfiguration);
                        continue;
                    }
                    if (hostConnectionPool.numConnections < n2 && this.connectionPool.numConnections < n3) {
                        httpConnection = this.connectionPool.createConnection(hostConfiguration);
                        continue;
                    }
                    if (hostConnectionPool.numConnections < n2 && this.connectionPool.freeConnections.size() > 0) {
                        this.connectionPool.deleteLeastUsedConnection();
                        httpConnection = this.connectionPool.createConnection(hostConfiguration);
                        continue;
                    }
                    try {
                        if (bl2 && l3 <= 0L) {
                            throw new ConnectionPoolTimeoutException("Timeout waiting for connection");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Unable to get a connection, waiting..., hostConfig=" + hostConfiguration);
                        }
                        if (waitingThread == null) {
                            waitingThread = new WaitingThread();
                            waitingThread.hostConnectionPool = hostConnectionPool;
                            waitingThread.thread = Thread.currentThread();
                        } else {
                            waitingThread.interruptedByConnectionPool = false;
                        }
                        if (bl2) {
                            l4 = System.currentTimeMillis();
                        }
                        hostConnectionPool.waitingThreads.addLast(waitingThread);
                        this.connectionPool.waitingThreads.addLast(waitingThread);
                        this.connectionPool.wait(l3);
                        if (waitingThread.interruptedByConnectionPool) break block20;
                        hostConnectionPool.waitingThreads.remove(waitingThread);
                    }
                    catch (InterruptedException interruptedException) {
                        block21: {
                            try {
                                if (!waitingThread.interruptedByConnectionPool) {
                                    LOG.debug("Interrupted while waiting for connection", interruptedException);
                                    throw new IllegalThreadStateException("Interrupted while waiting in MultiThreadedHttpConnectionManager");
                                }
                                if (waitingThread.interruptedByConnectionPool) break block21;
                                hostConnectionPool.waitingThreads.remove(waitingThread);
                            }
                            catch (Throwable throwable) {
                                if (!waitingThread.interruptedByConnectionPool) {
                                    hostConnectionPool.waitingThreads.remove(waitingThread);
                                    this.connectionPool.waitingThreads.remove(waitingThread);
                                }
                                if (bl2) {
                                    l5 = System.currentTimeMillis();
                                    l3 -= l5 - l4;
                                }
                                throw throwable;
                            }
                            this.connectionPool.waitingThreads.remove(waitingThread);
                        }
                        if (!bl2) continue;
                        l5 = System.currentTimeMillis();
                        l3 -= l5 - l4;
                        continue;
                    }
                    this.connectionPool.waitingThreads.remove(waitingThread);
                }
                if (!bl2) continue;
                l5 = System.currentTimeMillis();
                l3 -= l5 - l4;
            }
        }
        return httpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInPool(HostConfiguration hostConfiguration) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            HostConnectionPool hostConnectionPool = this.connectionPool.getHostPool(hostConfiguration);
            return hostConnectionPool.numConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInPool() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.connectionPool.numConnections;
        }
    }

    public int getConnectionsInUse(HostConfiguration hostConfiguration) {
        return this.getConnectionsInPool(hostConfiguration);
    }

    public int getConnectionsInUse() {
        return this.getConnectionsInPool();
    }

    public void deleteClosedConnections() {
        this.connectionPool.deleteClosedConnections();
    }

    public void closeIdleConnections(long l2) {
        this.connectionPool.closeIdleConnections(l2);
        this.deleteClosedConnections();
    }

    public void releaseConnection(HttpConnection httpConnection) {
        LOG.trace("enter HttpConnectionManager.releaseConnection(HttpConnection)");
        if (httpConnection instanceof HttpConnectionAdapter) {
            httpConnection = ((HttpConnectionAdapter)httpConnection).getWrappedConnection();
        }
        SimpleHttpConnectionManager.finishLastResponse(httpConnection);
        this.connectionPool.freeConnection(httpConnection);
    }

    private HostConfiguration configurationForConnection(HttpConnection httpConnection) {
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(httpConnection.getHost(), httpConnection.getPort(), httpConnection.getProtocol());
        if (httpConnection.getLocalAddress() != null) {
            hostConfiguration.setLocalAddress(httpConnection.getLocalAddress());
        }
        if (httpConnection.getProxyHost() != null) {
            hostConfiguration.setProxy(httpConnection.getProxyHost(), httpConnection.getProxyPort());
        }
        return hostConfiguration;
    }

    public HttpConnectionManagerParams getParams() {
        return this.params;
    }

    public void setParams(HttpConnectionManagerParams httpConnectionManagerParams) {
        if (httpConnectionManagerParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = httpConnectionManagerParams;
    }

    static {
        ALL_CONNECTION_MANAGERS = new WeakHashMap();
    }

    private static class HttpConnectionAdapter
    extends HttpConnection {
        private HttpConnection wrappedConnection;

        public HttpConnectionAdapter(HttpConnection httpConnection) {
            super(httpConnection.getHost(), httpConnection.getPort(), httpConnection.getProtocol());
            this.wrappedConnection = httpConnection;
        }

        protected boolean hasConnection() {
            return this.wrappedConnection != null;
        }

        HttpConnection getWrappedConnection() {
            return this.wrappedConnection;
        }

        public void close() {
            if (this.hasConnection()) {
                this.wrappedConnection.close();
            }
        }

        public InetAddress getLocalAddress() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getLocalAddress();
            }
            return null;
        }

        public boolean isStaleCheckingEnabled() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isStaleCheckingEnabled();
            }
            return false;
        }

        public void setLocalAddress(InetAddress inetAddress) {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setLocalAddress(inetAddress);
        }

        public void setStaleCheckingEnabled(boolean bl2) {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setStaleCheckingEnabled(bl2);
        }

        public String getHost() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getHost();
            }
            return null;
        }

        public HttpConnectionManager getHttpConnectionManager() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getHttpConnectionManager();
            }
            return null;
        }

        public InputStream getLastResponseInputStream() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getLastResponseInputStream();
            }
            return null;
        }

        public int getPort() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getPort();
            }
            return -1;
        }

        public Protocol getProtocol() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getProtocol();
            }
            return null;
        }

        public String getProxyHost() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getProxyHost();
            }
            return null;
        }

        public int getProxyPort() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getProxyPort();
            }
            return -1;
        }

        public OutputStream getRequestOutputStream() throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getRequestOutputStream();
            }
            return null;
        }

        public InputStream getResponseInputStream() throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getResponseInputStream();
            }
            return null;
        }

        public boolean isOpen() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isOpen();
            }
            return false;
        }

        public boolean closeIfStale() throws IOException {
            if (this.hasConnection()) {
                return this.wrappedConnection.closeIfStale();
            }
            return false;
        }

        public boolean isProxied() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isProxied();
            }
            return false;
        }

        public boolean isResponseAvailable() throws IOException {
            if (this.hasConnection()) {
                return this.wrappedConnection.isResponseAvailable();
            }
            return false;
        }

        public boolean isResponseAvailable(int n2) throws IOException {
            if (this.hasConnection()) {
                return this.wrappedConnection.isResponseAvailable(n2);
            }
            return false;
        }

        public boolean isSecure() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isSecure();
            }
            return false;
        }

        public boolean isTransparent() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isTransparent();
            }
            return false;
        }

        public void open() throws IOException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.open();
        }

        public void print(String string) throws IOException, IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.print(string);
        }

        public void printLine() throws IOException, IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.printLine();
        }

        public void printLine(String string) throws IOException, IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.printLine(string);
        }

        public String readLine() throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.readLine();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public String readLine(String string) throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.readLine(string);
            }
            throw new IllegalStateException("Connection has been released");
        }

        public void releaseConnection() {
            if (!this.isLocked() && this.hasConnection()) {
                HttpConnection httpConnection = this.wrappedConnection;
                this.wrappedConnection = null;
                httpConnection.releaseConnection();
            }
        }

        public void setConnectionTimeout(int n2) {
            if (this.hasConnection()) {
                this.wrappedConnection.setConnectionTimeout(n2);
            }
        }

        public void setHost(String string) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setHost(string);
            }
        }

        public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
            if (this.hasConnection()) {
                this.wrappedConnection.setHttpConnectionManager(httpConnectionManager);
            }
        }

        public void setLastResponseInputStream(InputStream inputStream) {
            if (this.hasConnection()) {
                this.wrappedConnection.setLastResponseInputStream(inputStream);
            }
        }

        public void setPort(int n2) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setPort(n2);
            }
        }

        public void setProtocol(Protocol protocol) {
            if (this.hasConnection()) {
                this.wrappedConnection.setProtocol(protocol);
            }
        }

        public void setProxyHost(String string) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setProxyHost(string);
            }
        }

        public void setProxyPort(int n2) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setProxyPort(n2);
            }
        }

        public void setSoTimeout(int n2) throws SocketException, IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setSoTimeout(n2);
            }
        }

        public void shutdownOutput() {
            if (this.hasConnection()) {
                this.wrappedConnection.shutdownOutput();
            }
        }

        public void tunnelCreated() throws IllegalStateException, IOException {
            if (this.hasConnection()) {
                this.wrappedConnection.tunnelCreated();
            }
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException, IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.write(byArray, n2, n3);
        }

        public void write(byte[] byArray) throws IOException, IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.write(byArray);
        }

        public void writeLine() throws IOException, IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.writeLine();
        }

        public void writeLine(byte[] byArray) throws IOException, IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.writeLine(byArray);
        }

        public void flushRequestOutputStream() throws IOException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.flushRequestOutputStream();
        }

        public int getSoTimeout() throws SocketException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getSoTimeout();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public String getVirtualHost() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getVirtualHost();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public void setVirtualHost(String string) throws IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setVirtualHost(string);
        }

        public int getSendBufferSize() throws SocketException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getSendBufferSize();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public void setSendBufferSize(int n2) throws SocketException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setSendBufferSize(n2);
        }

        public HttpConnectionParams getParams() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getParams();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public void setParams(HttpConnectionParams httpConnectionParams) {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setParams(httpConnectionParams);
        }

        public void print(String string, String string2) throws IOException, IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.print(string, string2);
        }

        public void printLine(String string, String string2) throws IOException, IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.printLine(string, string2);
        }

        public void setSocketTimeout(int n2) throws SocketException, IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setSocketTimeout(n2);
        }
    }

    private static class HttpConnectionWithReference
    extends HttpConnection {
        public WeakReference reference = new WeakReference<HttpConnectionWithReference>(this, MultiThreadedHttpConnectionManager.access$1500());

        public HttpConnectionWithReference(HostConfiguration hostConfiguration) {
            super(hostConfiguration);
        }
    }

    private static class ReferenceQueueThread
    extends Thread {
        private volatile boolean shutdown = false;

        public ReferenceQueueThread() {
            this.setDaemon(true);
            this.setName("MultiThreadedHttpConnectionManager cleanup");
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleReference(Reference reference) {
            ConnectionSource connectionSource = null;
            Map map = REFERENCE_TO_CONNECTION_SOURCE;
            synchronized (map) {
                connectionSource = (ConnectionSource)REFERENCE_TO_CONNECTION_SOURCE.remove(reference);
            }
            if (connectionSource != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection reclaimed by garbage collector, hostConfig=" + connectionSource.hostConfiguration);
                }
                connectionSource.connectionPool.handleLostConnection(connectionSource.hostConfiguration);
            }
        }

        public void run() {
            while (!this.shutdown) {
                try {
                    Reference reference = REFERENCE_QUEUE.remove();
                    if (reference == null) continue;
                    this.handleReference(reference);
                }
                catch (InterruptedException interruptedException) {
                    LOG.debug("ReferenceQueueThread interrupted", interruptedException);
                }
            }
        }
    }

    private static class WaitingThread {
        public Thread thread;
        public HostConnectionPool hostConnectionPool;
        public boolean interruptedByConnectionPool = false;

        private WaitingThread() {
        }
    }

    private static class HostConnectionPool {
        public HostConfiguration hostConfiguration;
        public LinkedList freeConnections = new LinkedList();
        public LinkedList waitingThreads = new LinkedList();
        public int numConnections = 0;

        private HostConnectionPool() {
        }
    }

    private static class ConnectionSource {
        public ConnectionPool connectionPool;
        public HostConfiguration hostConfiguration;

        private ConnectionSource() {
        }
    }

    private class ConnectionPool {
        private LinkedList freeConnections = new LinkedList();
        private LinkedList waitingThreads = new LinkedList();
        private final Map mapHosts = new HashMap();
        private IdleConnectionHandler idleConnectionHandler = new IdleConnectionHandler();
        private int numConnections = 0;

        private ConnectionPool() {
        }

        public synchronized void shutdown() {
            Object object;
            Iterator iterator = this.freeConnections.iterator();
            while (iterator.hasNext()) {
                object = (HttpConnection)iterator.next();
                iterator.remove();
                ((HttpConnection)object).close();
            }
            MultiThreadedHttpConnectionManager.shutdownCheckedOutConnections(this);
            iterator = this.waitingThreads.iterator();
            while (iterator.hasNext()) {
                object = (WaitingThread)iterator.next();
                iterator.remove();
                ((WaitingThread)object).interruptedByConnectionPool = true;
                ((WaitingThread)object).thread.interrupt();
            }
            this.mapHosts.clear();
            this.idleConnectionHandler.removeAll();
        }

        public synchronized HttpConnection createConnection(HostConfiguration hostConfiguration) {
            HostConnectionPool hostConnectionPool = this.getHostPool(hostConfiguration);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Allocating new connection, hostConfig=" + hostConfiguration);
            }
            HttpConnectionWithReference httpConnectionWithReference = new HttpConnectionWithReference(hostConfiguration);
            httpConnectionWithReference.getParams().setDefaults(MultiThreadedHttpConnectionManager.this.params);
            httpConnectionWithReference.setHttpConnectionManager(MultiThreadedHttpConnectionManager.this);
            ++this.numConnections;
            ++hostConnectionPool.numConnections;
            MultiThreadedHttpConnectionManager.storeReferenceToConnection(httpConnectionWithReference, hostConfiguration, this);
            return httpConnectionWithReference;
        }

        public synchronized void handleLostConnection(HostConfiguration hostConfiguration) {
            HostConnectionPool hostConnectionPool = this.getHostPool(hostConfiguration);
            --hostConnectionPool.numConnections;
            if (hostConnectionPool.numConnections == 0) {
                this.mapHosts.remove(hostConfiguration);
            }
            --this.numConnections;
            this.notifyWaitingThread(hostConfiguration);
        }

        public synchronized HostConnectionPool getHostPool(HostConfiguration hostConfiguration) {
            LOG.trace("enter HttpConnectionManager.ConnectionPool.getHostPool(HostConfiguration)");
            HostConnectionPool hostConnectionPool = (HostConnectionPool)this.mapHosts.get(hostConfiguration);
            if (hostConnectionPool == null) {
                hostConnectionPool = new HostConnectionPool();
                hostConnectionPool.hostConfiguration = hostConfiguration;
                this.mapHosts.put(hostConfiguration, hostConnectionPool);
            }
            return hostConnectionPool;
        }

        public synchronized HttpConnection getFreeConnection(HostConfiguration hostConfiguration) {
            HttpConnectionWithReference httpConnectionWithReference = null;
            HostConnectionPool hostConnectionPool = this.getHostPool(hostConfiguration);
            if (hostConnectionPool.freeConnections.size() > 0) {
                httpConnectionWithReference = (HttpConnectionWithReference)hostConnectionPool.freeConnections.removeLast();
                this.freeConnections.remove(httpConnectionWithReference);
                MultiThreadedHttpConnectionManager.storeReferenceToConnection(httpConnectionWithReference, hostConfiguration, this);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Getting free connection, hostConfig=" + hostConfiguration);
                }
                this.idleConnectionHandler.remove(httpConnectionWithReference);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("There were no free connections to get, hostConfig=" + hostConfiguration);
            }
            return httpConnectionWithReference;
        }

        public synchronized void deleteClosedConnections() {
            Iterator iterator = this.freeConnections.iterator();
            while (iterator.hasNext()) {
                HttpConnection httpConnection = (HttpConnection)iterator.next();
                if (httpConnection.isOpen()) continue;
                iterator.remove();
                this.deleteConnection(httpConnection);
            }
        }

        public synchronized void closeIdleConnections(long l2) {
            this.idleConnectionHandler.closeIdleConnections(l2);
        }

        private synchronized void deleteConnection(HttpConnection httpConnection) {
            HostConfiguration hostConfiguration = MultiThreadedHttpConnectionManager.this.configurationForConnection(httpConnection);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reclaiming connection, hostConfig=" + hostConfiguration);
            }
            httpConnection.close();
            HostConnectionPool hostConnectionPool = this.getHostPool(hostConfiguration);
            hostConnectionPool.freeConnections.remove(httpConnection);
            --hostConnectionPool.numConnections;
            --this.numConnections;
            if (hostConnectionPool.numConnections == 0) {
                this.mapHosts.remove(hostConfiguration);
            }
            this.idleConnectionHandler.remove(httpConnection);
        }

        public synchronized void deleteLeastUsedConnection() {
            HttpConnection httpConnection = (HttpConnection)this.freeConnections.removeFirst();
            if (httpConnection != null) {
                this.deleteConnection(httpConnection);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Attempted to reclaim an unused connection but there were none.");
            }
        }

        public synchronized void notifyWaitingThread(HostConfiguration hostConfiguration) {
            this.notifyWaitingThread(this.getHostPool(hostConfiguration));
        }

        public synchronized void notifyWaitingThread(HostConnectionPool hostConnectionPool) {
            WaitingThread waitingThread = null;
            if (hostConnectionPool.waitingThreads.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Notifying thread waiting on host pool, hostConfig=" + hostConnectionPool.hostConfiguration);
                }
                waitingThread = (WaitingThread)hostConnectionPool.waitingThreads.removeFirst();
                this.waitingThreads.remove(waitingThread);
            } else if (this.waitingThreads.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No-one waiting on host pool, notifying next waiting thread.");
                }
                waitingThread = (WaitingThread)this.waitingThreads.removeFirst();
                waitingThread.hostConnectionPool.waitingThreads.remove(waitingThread);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying no-one, there are no waiting threads");
            }
            if (waitingThread != null) {
                waitingThread.interruptedByConnectionPool = true;
                waitingThread.thread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void freeConnection(HttpConnection httpConnection) {
            HostConfiguration hostConfiguration = MultiThreadedHttpConnectionManager.this.configurationForConnection(httpConnection);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Freeing connection, hostConfig=" + hostConfiguration);
            }
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                if (MultiThreadedHttpConnectionManager.this.shutdown) {
                    httpConnection.close();
                    return;
                }
                HostConnectionPool hostConnectionPool = this.getHostPool(hostConfiguration);
                hostConnectionPool.freeConnections.add(httpConnection);
                if (hostConnectionPool.numConnections == 0) {
                    LOG.error("Host connection pool not found, hostConfig=" + hostConfiguration);
                    hostConnectionPool.numConnections = 1;
                }
                this.freeConnections.add(httpConnection);
                MultiThreadedHttpConnectionManager.removeReferenceToConnection((HttpConnectionWithReference)httpConnection);
                if (this.numConnections == 0) {
                    LOG.error("Host connection pool not found, hostConfig=" + hostConfiguration);
                    this.numConnections = 1;
                }
                this.idleConnectionHandler.add(httpConnection);
                this.notifyWaitingThread(hostConnectionPool);
            }
        }
    }
}

