/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpState {
    private HashMap credMap = new HashMap();
    private HashMap proxyCred = new HashMap();
    private ArrayList cookies = new ArrayList();
    private boolean preemptive = false;
    private int cookiePolicy = -1;
    public static final String PREEMPTIVE_PROPERTY = "httpclient.authentication.preemptive";
    public static final String PREEMPTIVE_DEFAULT = "false";
    private static final Log LOG = LogFactory.getLog(HttpState.class);

    public synchronized void addCookie(Cookie cookie) {
        LOG.trace("enter HttpState.addCookie(Cookie)");
        if (cookie != null) {
            Iterator iterator = this.cookies.iterator();
            while (iterator.hasNext()) {
                Cookie cookie2 = (Cookie)iterator.next();
                if (!cookie.equals(cookie2)) continue;
                iterator.remove();
                break;
            }
            if (!cookie.isExpired()) {
                this.cookies.add(cookie);
            }
        }
    }

    public synchronized void addCookies(Cookie[] cookieArray) {
        LOG.trace("enter HttpState.addCookies(Cookie[])");
        if (cookieArray != null) {
            for (int i2 = 0; i2 < cookieArray.length; ++i2) {
                this.addCookie(cookieArray[i2]);
            }
        }
    }

    public synchronized Cookie[] getCookies() {
        LOG.trace("enter HttpState.getCookies()");
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public synchronized Cookie[] getCookies(String string, int n2, String string2, boolean bl2) {
        LOG.trace("enter HttpState.getCookies(String, int, String, boolean)");
        CookieSpec cookieSpec = CookiePolicy.getDefaultSpec();
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>(this.cookies.size());
        int n3 = this.cookies.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Cookie cookie = (Cookie)this.cookies.get(i2);
            if (!cookieSpec.match(string, n2, string2, bl2, cookie)) continue;
            arrayList.add(cookie);
        }
        return arrayList.toArray(new Cookie[arrayList.size()]);
    }

    public synchronized boolean purgeExpiredCookies() {
        LOG.trace("enter HttpState.purgeExpiredCookies()");
        return this.purgeExpiredCookies(new Date());
    }

    public synchronized boolean purgeExpiredCookies(Date date) {
        LOG.trace("enter HttpState.purgeExpiredCookies(Date)");
        boolean bl2 = false;
        Iterator iterator = this.cookies.iterator();
        while (iterator.hasNext()) {
            if (!((Cookie)iterator.next()).isExpired(date)) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public int getCookiePolicy() {
        return this.cookiePolicy;
    }

    public void setAuthenticationPreemptive(boolean bl2) {
        this.preemptive = bl2;
    }

    public boolean isAuthenticationPreemptive() {
        return this.preemptive;
    }

    public void setCookiePolicy(int n2) {
        this.cookiePolicy = n2;
    }

    public synchronized void setCredentials(String string, String string2, Credentials credentials) {
        LOG.trace("enter HttpState.setCredentials(String, String, Credentials)");
        this.credMap.put(new AuthScope(string2, -1, string, AuthScope.ANY_SCHEME), credentials);
    }

    public synchronized void setCredentials(AuthScope authScope, Credentials credentials) {
        if (authScope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        LOG.trace("enter HttpState.setCredentials(AuthScope, Credentials)");
        this.credMap.put(authScope, credentials);
    }

    private static Credentials matchCredentials(HashMap hashMap, AuthScope authScope) {
        Credentials credentials = (Credentials)hashMap.get(authScope);
        if (credentials == null) {
            int n2 = -1;
            AuthScope authScope2 = null;
            for (AuthScope authScope3 : hashMap.keySet()) {
                int n3 = authScope.match(authScope3);
                if (n3 <= n2) continue;
                n2 = n3;
                authScope2 = authScope3;
            }
            if (authScope2 != null) {
                credentials = (Credentials)hashMap.get(authScope2);
            }
        }
        return credentials;
    }

    public synchronized Credentials getCredentials(String string, String string2) {
        LOG.trace("enter HttpState.getCredentials(String, String");
        return HttpState.matchCredentials(this.credMap, new AuthScope(string2, -1, string, AuthScope.ANY_SCHEME));
    }

    public synchronized Credentials getCredentials(AuthScope authScope) {
        if (authScope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        LOG.trace("enter HttpState.getCredentials(AuthScope)");
        return HttpState.matchCredentials(this.credMap, authScope);
    }

    public synchronized void setProxyCredentials(String string, String string2, Credentials credentials) {
        LOG.trace("enter HttpState.setProxyCredentials(String, String, Credentials");
        this.proxyCred.put(new AuthScope(string2, -1, string, AuthScope.ANY_SCHEME), credentials);
    }

    public synchronized void setProxyCredentials(AuthScope authScope, Credentials credentials) {
        if (authScope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        LOG.trace("enter HttpState.setProxyCredentials(AuthScope, Credentials)");
        this.proxyCred.put(authScope, credentials);
    }

    public synchronized Credentials getProxyCredentials(String string, String string2) {
        LOG.trace("enter HttpState.getCredentials(String, String");
        return HttpState.matchCredentials(this.proxyCred, new AuthScope(string2, -1, string, AuthScope.ANY_SCHEME));
    }

    public synchronized Credentials getProxyCredentials(AuthScope authScope) {
        if (authScope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        LOG.trace("enter HttpState.getProxyCredentials(AuthScope)");
        return HttpState.matchCredentials(this.proxyCred, authScope);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(HttpState.getCredentialsStringRepresentation(this.proxyCred));
        stringBuffer.append(" | ");
        stringBuffer.append(HttpState.getCredentialsStringRepresentation(this.credMap));
        stringBuffer.append(" | ");
        stringBuffer.append(HttpState.getCookiesStringRepresentation(this.cookies));
        stringBuffer.append("]");
        String string = stringBuffer.toString();
        return string;
    }

    private static String getCredentialsStringRepresentation(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object k2 : map.keySet()) {
            Credentials credentials = (Credentials)map.get(k2);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(k2);
            stringBuffer.append("#");
            stringBuffer.append(credentials.toString());
        }
        return stringBuffer.toString();
    }

    private static String getCookiesStringRepresentation(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Cookie cookie : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("#");
            }
            stringBuffer.append(cookie.toExternalForm());
        }
        return stringBuffer.toString();
    }

    public void clearCredentials() {
        this.credMap.clear();
    }

    public void clearProxyCredentials() {
        this.proxyCred.clear();
    }

    public synchronized void clearCookies() {
        this.cookies.clear();
    }

    public void clear() {
        this.clearCookies();
        this.clearCredentials();
        this.clearProxyCredentials();
    }
}

