/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Collection;
import org.apache.commons.httpclient.AutoCloseInputStream;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpContentTooLargeException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MethodRetryHandler;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.ResponseConsumedWatcher;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.httpclient.WireLogInputStream;
import org.apache.commons.httpclient.auth.AuthState;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.CookieVersionSupport;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.httpclient.util.ExceptionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HttpMethodBase
implements HttpMethod {
    private static final Log LOG = LogFactory.getLog(HttpMethodBase.class);
    private HeaderGroup requestHeaders = new HeaderGroup();
    protected StatusLine statusLine = null;
    private HeaderGroup responseHeaders = new HeaderGroup();
    private HeaderGroup responseTrailerHeaders = new HeaderGroup();
    private String path = null;
    private String queryString = null;
    private InputStream responseStream = null;
    private HttpConnection responseConnection = null;
    private byte[] responseBody = null;
    private boolean followRedirects = false;
    private boolean doAuthentication = true;
    private HttpMethodParams params = new HttpMethodParams();
    private AuthState hostAuthState = new AuthState();
    private AuthState proxyAuthState = new AuthState();
    private boolean used = false;
    private int recoverableExceptionCount = 0;
    private HttpHost httphost = null;
    private MethodRetryHandler methodRetryHandler;
    private boolean connectionCloseForced = false;
    private static final int RESPONSE_WAIT_TIME_MS = 3000;
    protected HttpVersion effectiveVersion = null;
    private volatile boolean aborted = false;
    private boolean requestSent = false;
    private CookieSpec cookiespec = null;
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 4096;

    public HttpMethodBase() {
    }

    public HttpMethodBase(String string) throws IllegalArgumentException, IllegalStateException {
        try {
            if (string == null || string.equals("")) {
                string = "/";
            }
            String string2 = this.getParams().getUriCharset();
            this.setURI(new URI(string, true, string2));
        }
        catch (URIException uRIException) {
            throw new IllegalArgumentException("Invalid uri '" + string + "': " + uRIException.getMessage());
        }
    }

    public abstract String getName();

    public URI getURI() throws URIException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.httphost != null) {
            stringBuffer.append(this.httphost.getProtocol().getScheme());
            stringBuffer.append("://");
            stringBuffer.append(this.httphost.getHostName());
            int n2 = this.httphost.getPort();
            if (n2 != -1 && n2 != this.httphost.getProtocol().getDefaultPort()) {
                stringBuffer.append(":");
                stringBuffer.append(n2);
            }
        }
        stringBuffer.append(this.path);
        if (this.queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.queryString);
        }
        String string = this.getParams().getUriCharset();
        return new URI(stringBuffer.toString(), true, string);
    }

    public void setURI(URI uRI) throws URIException {
        if (uRI.isAbsoluteURI()) {
            this.httphost = new HttpHost(uRI);
        }
        this.setPath(uRI.getPath() == null ? "/" : uRI.getEscapedPath());
        this.setQueryString(uRI.getEscapedQuery());
    }

    public void setFollowRedirects(boolean bl2) {
        this.followRedirects = bl2;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setHttp11(boolean bl2) {
        if (bl2) {
            this.params.setVersion(HttpVersion.HTTP_1_1);
        } else {
            this.params.setVersion(HttpVersion.HTTP_1_0);
        }
    }

    public boolean getDoAuthentication() {
        return this.doAuthentication;
    }

    public void setDoAuthentication(boolean bl2) {
        this.doAuthentication = bl2;
    }

    public boolean isHttp11() {
        return this.params.getVersion().equals(HttpVersion.HTTP_1_1);
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void addRequestHeader(Header header) {
        LOG.trace("HttpMethodBase.addRequestHeader(Header)");
        if (header == null) {
            LOG.debug("null header value ignored");
        } else {
            this.getRequestHeaderGroup().addHeader(header);
        }
    }

    public void addResponseFooter(Header header) {
        this.getResponseTrailerHeaderGroup().addHeader(header);
    }

    public String getPath() {
        return this.path == null || this.path.equals("") ? "/" : this.path;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void setQueryString(NameValuePair[] nameValuePairArray) {
        LOG.trace("enter HttpMethodBase.setQueryString(NameValuePair[])");
        this.queryString = EncodingUtil.formUrlEncode(nameValuePairArray, "UTF-8");
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setRequestHeader(String string, String string2) {
        Header header = new Header(string, string2);
        this.setRequestHeader(header);
    }

    public void setRequestHeader(Header header) {
        Header[] headerArray = this.getRequestHeaderGroup().getHeaders(header.getName());
        for (int i2 = 0; i2 < headerArray.length; ++i2) {
            this.getRequestHeaderGroup().removeHeader(headerArray[i2]);
        }
        this.getRequestHeaderGroup().addHeader(header);
    }

    public Header getRequestHeader(String string) {
        if (string == null) {
            return null;
        }
        return this.getRequestHeaderGroup().getCondensedHeader(string);
    }

    public Header[] getRequestHeaders() {
        return this.getRequestHeaderGroup().getAllHeaders();
    }

    public Header[] getRequestHeaders(String string) {
        return this.getRequestHeaderGroup().getHeaders(string);
    }

    protected HeaderGroup getRequestHeaderGroup() {
        return this.requestHeaders;
    }

    protected HeaderGroup getResponseTrailerHeaderGroup() {
        return this.responseTrailerHeaders;
    }

    protected HeaderGroup getResponseHeaderGroup() {
        return this.responseHeaders;
    }

    public Header[] getResponseHeaders(String string) {
        return this.getResponseHeaderGroup().getHeaders(string);
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    private boolean responseAvailable() {
        return this.responseBody != null || this.responseStream != null;
    }

    public Header[] getResponseHeaders() {
        return this.getResponseHeaderGroup().getAllHeaders();
    }

    public Header getResponseHeader(String string) {
        if (string == null) {
            return null;
        }
        return this.getResponseHeaderGroup().getCondensedHeader(string);
    }

    public long getResponseContentLength() {
        Header[] headerArray = this.getResponseHeaderGroup().getHeaders("Content-Length");
        if (headerArray.length == 0) {
            return -1L;
        }
        if (headerArray.length > 1) {
            LOG.warn("Multiple content-length headers detected");
        }
        for (int i2 = headerArray.length - 1; i2 >= 0; --i2) {
            Header header = headerArray[i2];
            try {
                return Long.parseLong(header.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Invalid content-length value: " + numberFormatException.getMessage());
                continue;
            }
        }
        return -1L;
    }

    public byte[] getResponseBody() throws IOException {
        InputStream inputStream;
        if (this.responseBody == null && (inputStream = this.getResponseBodyAsStream()) != null) {
            int n2;
            long l2 = this.getResponseContentLength();
            if (l2 > Integer.MAX_VALUE) {
                throw new IOException("Content too large to be buffered: " + l2 + " bytes");
            }
            int n3 = this.getParams().getIntParameter("http.method.response.buffer.warnlimit", 0x100000);
            if (l2 == -1L || l2 > (long)n3) {
                LOG.warn("Going to buffer response body of large or unknown size. Using getResponseBodyAsStream instead is recommended.");
            }
            LOG.debug("Buffering response body");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(l2 > 0L ? (int)l2 : 4096);
            byte[] byArray = new byte[4096];
            while ((n2 = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.close();
            this.setResponseStream(null);
            this.responseBody = byteArrayOutputStream.toByteArray();
        }
        return this.responseBody;
    }

    public byte[] getResponseBody(int n2) throws IOException {
        InputStream inputStream;
        if (n2 < 0) {
            throw new IllegalArgumentException("maxlen must be positive");
        }
        if (this.responseBody == null && (inputStream = this.getResponseBodyAsStream()) != null) {
            int n3;
            long l2 = this.getResponseContentLength();
            if (l2 != -1L && l2 > (long)n2) {
                throw new HttpContentTooLargeException("Content-Length is " + l2, n2);
            }
            LOG.debug("Buffering response body");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(l2 > 0L ? (int)l2 : 4096);
            byte[] byArray = new byte[2048];
            int n4 = 0;
            while ((n3 = inputStream.read(byArray, 0, Math.min(byArray.length, n2 - n4))) != -1) {
                byteArrayOutputStream.write(byArray, 0, n3);
                if ((n4 += n3) < n2) continue;
            }
            this.setResponseStream(null);
            if (n4 == n2 && inputStream.read() != -1) {
                throw new HttpContentTooLargeException("Content-Length not known but larger than " + n2, n2);
            }
            this.responseBody = byteArrayOutputStream.toByteArray();
        }
        return this.responseBody;
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        if (this.responseStream != null) {
            return this.responseStream;
        }
        if (this.responseBody != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.responseBody);
            LOG.debug("re-creating response stream from byte array");
            return byteArrayInputStream;
        }
        return null;
    }

    public String getResponseBodyAsString() throws IOException {
        byte[] byArray = null;
        if (this.responseAvailable()) {
            byArray = this.getResponseBody();
        }
        if (byArray != null) {
            return EncodingUtil.getString(byArray, this.getResponseCharSet());
        }
        return null;
    }

    public String getResponseBodyAsString(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("maxlen must be positive");
        }
        byte[] byArray = null;
        if (this.responseAvailable()) {
            byArray = this.getResponseBody(n2);
        }
        if (byArray != null) {
            return EncodingUtil.getString(byArray, this.getResponseCharSet());
        }
        return null;
    }

    public Header[] getResponseFooters() {
        return this.getResponseTrailerHeaderGroup().getAllHeaders();
    }

    public Header getResponseFooter(String string) {
        if (string == null) {
            return null;
        }
        return this.getResponseTrailerHeaderGroup().getCondensedHeader(string);
    }

    protected void setResponseStream(InputStream inputStream) {
        this.responseStream = inputStream;
    }

    protected InputStream getResponseStream() {
        return this.responseStream;
    }

    public String getStatusText() {
        return this.statusLine.getReasonPhrase();
    }

    public void setStrictMode(boolean bl2) {
        if (bl2) {
            this.params.makeStrict();
        } else {
            this.params.makeLenient();
        }
    }

    public boolean isStrictMode() {
        return false;
    }

    public void addRequestHeader(String string, String string2) {
        this.addRequestHeader(new Header(string, string2));
    }

    protected boolean isConnectionCloseForced() {
        return this.connectionCloseForced;
    }

    protected void setConnectionCloseForced(boolean bl2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Force-close connection: " + bl2);
        }
        this.connectionCloseForced = bl2;
    }

    protected boolean shouldCloseConnection(HttpConnection httpConnection) {
        if (this.isConnectionCloseForced()) {
            LOG.debug("Should force-close connection.");
            return true;
        }
        Header header = null;
        if (!httpConnection.isTransparent()) {
            header = this.responseHeaders.getFirstHeader("proxy-connection");
        }
        if (header == null) {
            header = this.responseHeaders.getFirstHeader("connection");
        }
        if (header == null) {
            header = this.requestHeaders.getFirstHeader("connection");
        }
        if (header != null) {
            if (header.getValue().equalsIgnoreCase("close")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Should close connection in response to directive: " + header.getValue());
                }
                return true;
            }
            if (header.getValue().equalsIgnoreCase("keep-alive")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Should NOT close connection in response to directive: " + header.getValue());
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unknown directive: " + header.toExternalForm());
            }
        }
        LOG.debug("Resorting to protocol version default close connection policy");
        if (this.effectiveVersion.greaterEquals(HttpVersion.HTTP_1_1)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Should NOT close connection, using " + this.effectiveVersion.toString());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Should close connection, using " + this.effectiveVersion.toString());
        }
        return this.effectiveVersion.lessEquals(HttpVersion.HTTP_1_0);
    }

    private void checkExecuteConditions(HttpState httpState, HttpConnection httpConnection) throws HttpException {
        if (httpState == null) {
            throw new IllegalArgumentException("HttpState parameter may not be null");
        }
        if (httpConnection == null) {
            throw new IllegalArgumentException("HttpConnection parameter may not be null");
        }
        if (this.aborted) {
            throw new IllegalStateException("Method has been aborted");
        }
        if (!this.validate()) {
            throw new ProtocolException("HttpMethodBase object not valid");
        }
    }

    public int execute(HttpState httpState, HttpConnection httpConnection) throws HttpException, IOException {
        LOG.trace("enter HttpMethodBase.execute(HttpState, HttpConnection)");
        this.responseConnection = httpConnection;
        this.checkExecuteConditions(httpState, httpConnection);
        this.statusLine = null;
        this.connectionCloseForced = false;
        httpConnection.setLastResponseInputStream(null);
        if (this.effectiveVersion == null) {
            this.effectiveVersion = this.params.getVersion();
        }
        this.writeRequest(httpState, httpConnection);
        this.requestSent = true;
        this.readResponse(httpState, httpConnection);
        this.used = true;
        return this.statusLine.getStatusCode();
    }

    public void abort() {
        if (this.aborted) {
            return;
        }
        this.aborted = true;
        HttpConnection httpConnection = this.responseConnection;
        if (httpConnection != null) {
            httpConnection.close();
        }
    }

    public boolean hasBeenUsed() {
        return this.used;
    }

    public void recycle() {
        LOG.trace("enter HttpMethodBase.recycle()");
        this.releaseConnection();
        this.path = null;
        this.followRedirects = false;
        this.doAuthentication = true;
        this.queryString = null;
        this.getRequestHeaderGroup().clear();
        this.getResponseHeaderGroup().clear();
        this.getResponseTrailerHeaderGroup().clear();
        this.statusLine = null;
        this.effectiveVersion = null;
        this.aborted = false;
        this.used = false;
        this.params = new HttpMethodParams();
        this.responseBody = null;
        this.recoverableExceptionCount = 0;
        this.connectionCloseForced = false;
        this.hostAuthState.invalidate();
        this.proxyAuthState.invalidate();
        this.cookiespec = null;
        this.requestSent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection() {
        try {
            if (this.responseStream != null) {
                try {
                    this.responseStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.ensureConnectionRelease();
        }
    }

    public void removeRequestHeader(String string) {
        Header[] headerArray = this.getRequestHeaderGroup().getHeaders(string);
        for (int i2 = 0; i2 < headerArray.length; ++i2) {
            this.getRequestHeaderGroup().removeHeader(headerArray[i2]);
        }
    }

    public void removeRequestHeader(Header header) {
        if (header == null) {
            return;
        }
        this.getRequestHeaderGroup().removeHeader(header);
    }

    public boolean validate() {
        return true;
    }

    private CookieSpec getCookieSpec(HttpState httpState) {
        if (this.cookiespec == null) {
            int n2 = httpState.getCookiePolicy();
            this.cookiespec = n2 == -1 ? CookiePolicy.getCookieSpec(this.params.getCookiePolicy()) : CookiePolicy.getSpecByPolicy(n2);
            this.cookiespec.setValidDateFormats((Collection)this.params.getParameter("http.dateparser.patterns"));
        }
        return this.cookiespec;
    }

    protected void addCookieRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        Cookie[] cookieArray;
        Object object;
        LOG.trace("enter HttpMethodBase.addCookieRequestHeader(HttpState, HttpConnection)");
        Header[] headerArray = this.getRequestHeaderGroup().getHeaders("Cookie");
        for (int i2 = 0; i2 < headerArray.length; ++i2) {
            object = headerArray[i2];
            if (!((Header)object).isAutogenerated()) continue;
            this.getRequestHeaderGroup().removeHeader((Header)object);
        }
        CookieSpec cookieSpec = this.getCookieSpec(httpState);
        object = this.params.getVirtualHost();
        if (object == null) {
            object = httpConnection.getHost();
        }
        if ((cookieArray = cookieSpec.match((String)object, httpConnection.getPort(), this.getPath(), httpConnection.isSecure(), httpState.getCookies())) != null && cookieArray.length > 0) {
            Object object2;
            if (this.getParams().isParameterTrue("http.protocol.single-cookie-header")) {
                object2 = cookieSpec.formatCookies(cookieArray);
                this.getRequestHeaderGroup().addHeader(new Header("Cookie", (String)object2, true));
            } else {
                for (int i3 = 0; i3 < cookieArray.length; ++i3) {
                    String string = cookieSpec.formatCookie(cookieArray[i3]);
                    this.getRequestHeaderGroup().addHeader(new Header("Cookie", string, true));
                }
            }
            if (cookieSpec instanceof CookieVersionSupport) {
                object2 = (CookieVersionSupport)((Object)cookieSpec);
                int n2 = object2.getVersion();
                boolean bl2 = false;
                for (int i4 = 0; i4 < cookieArray.length; ++i4) {
                    if (n2 == cookieArray[i4].getVersion()) continue;
                    bl2 = true;
                }
                if (bl2) {
                    this.getRequestHeaderGroup().addHeader(object2.getVersionHeader());
                }
            }
        }
    }

    protected void addHostRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.addHostRequestHeader(HttpState, HttpConnection)");
        String string = this.params.getVirtualHost();
        if (string != null) {
            LOG.debug("Using virtual host name: " + string);
        } else {
            string = httpConnection.getHost();
        }
        int n2 = httpConnection.getPort();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding Host request header");
        }
        if (httpConnection.getProtocol().getDefaultPort() != n2) {
            string = string + ":" + n2;
        }
        this.setRequestHeader("Host", string);
    }

    protected void addProxyConnectionHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.addProxyConnectionHeader(HttpState, HttpConnection)");
        if (!httpConnection.isTransparent() && this.getRequestHeader("Proxy-Connection") == null) {
            this.addRequestHeader("Proxy-Connection", "Keep-Alive");
        }
    }

    protected void addRequestHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.addRequestHeaders(HttpState, HttpConnection)");
        this.addUserAgentRequestHeader(httpState, httpConnection);
        this.addHostRequestHeader(httpState, httpConnection);
        this.addCookieRequestHeader(httpState, httpConnection);
        this.addProxyConnectionHeader(httpState, httpConnection);
    }

    protected void addUserAgentRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.addUserAgentRequestHeaders(HttpState, HttpConnection)");
        if (this.getRequestHeader("User-Agent") == null) {
            String string = (String)this.getParams().getParameter("http.useragent");
            if (string == null) {
                string = "Jakarta Commons-HttpClient";
            }
            this.setRequestHeader("User-Agent", string);
        }
    }

    protected void checkNotUsed() throws IllegalStateException {
        if (this.used) {
            throw new IllegalStateException("Already used.");
        }
    }

    protected void checkUsed() throws IllegalStateException {
        if (!this.used) {
            throw new IllegalStateException("Not Used.");
        }
    }

    protected static String generateRequestLine(HttpConnection httpConnection, String string, String string2, String string3, String string4) {
        LOG.trace("enter HttpMethodBase.generateRequestLine(HttpConnection, String, String, String, String)");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" ");
        if (!httpConnection.isTransparent()) {
            Protocol protocol = httpConnection.getProtocol();
            stringBuffer.append(protocol.getScheme().toLowerCase());
            stringBuffer.append("://");
            stringBuffer.append(httpConnection.getHost());
            if (httpConnection.getPort() != -1 && httpConnection.getPort() != protocol.getDefaultPort()) {
                stringBuffer.append(":");
                stringBuffer.append(httpConnection.getPort());
            }
        }
        if (string2 == null) {
            stringBuffer.append("/");
        } else {
            if (!httpConnection.isTransparent() && !string2.startsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            if (string3.indexOf("?") != 0) {
                stringBuffer.append("?");
            }
            stringBuffer.append(string3);
        }
        stringBuffer.append(" ");
        stringBuffer.append(string4);
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
    }

    protected void processResponseHeaders(HttpState httpState, HttpConnection httpConnection) {
        CookieVersionSupport cookieVersionSupport;
        LOG.trace("enter HttpMethodBase.processResponseHeaders(HttpState, HttpConnection)");
        CookieSpec cookieSpec = this.getCookieSpec(httpState);
        Header[] headerArray = this.getResponseHeaderGroup().getHeaders("set-cookie");
        this.processCookieHeaders(cookieSpec, headerArray, httpState, httpConnection);
        if (cookieSpec instanceof CookieVersionSupport && (cookieVersionSupport = (CookieVersionSupport)((Object)cookieSpec)).getVersion() > 0) {
            headerArray = this.getResponseHeaderGroup().getHeaders("set-cookie2");
            this.processCookieHeaders(cookieSpec, headerArray, httpState, httpConnection);
        }
    }

    protected void processCookieHeaders(CookieSpec cookieSpec, Header[] headerArray, HttpState httpState, HttpConnection httpConnection) {
        LOG.trace("enter HttpMethodBase.processCookieHeaders(Header[], HttpState, HttpConnection)");
        String string = this.params.getVirtualHost();
        if (string == null) {
            string = httpConnection.getHost();
        }
        for (int i2 = 0; i2 < headerArray.length; ++i2) {
            Cookie[] cookieArray;
            block7: {
                Header header = headerArray[i2];
                cookieArray = null;
                try {
                    cookieArray = cookieSpec.parse(string, httpConnection.getPort(), this.getPath(), httpConnection.isSecure(), header);
                }
                catch (MalformedCookieException malformedCookieException) {
                    if (!LOG.isWarnEnabled()) break block7;
                    LOG.warn("Invalid cookie header: \"" + header.getValue() + "\". " + malformedCookieException.getMessage());
                }
            }
            if (cookieArray == null) continue;
            for (int i3 = 0; i3 < cookieArray.length; ++i3) {
                Cookie cookie = cookieArray[i3];
                try {
                    cookieSpec.validate(string, httpConnection.getPort(), this.getPath(), httpConnection.isSecure(), cookie);
                    httpState.addCookie(cookie);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Cookie accepted: \"" + cookieSpec.formatCookie(cookie) + "\"");
                    continue;
                }
                catch (MalformedCookieException malformedCookieException) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("Cookie rejected: \"" + cookieSpec.formatCookie(cookie) + "\". " + malformedCookieException.getMessage());
                }
            }
        }
    }

    protected void processStatusLine(HttpState httpState, HttpConnection httpConnection) {
    }

    protected void readResponse(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.readResponse(HttpState, HttpConnection)");
        while (this.statusLine == null) {
            this.readStatusLine(httpState, httpConnection);
            this.processStatusLine(httpState, httpConnection);
            this.readResponseHeaders(httpState, httpConnection);
            this.processResponseHeaders(httpState, httpConnection);
            int n2 = this.statusLine.getStatusCode();
            if (n2 < 100 || n2 >= 200) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info("Discarding unexpected response: " + this.statusLine.toString());
            }
            this.statusLine = null;
        }
        this.readResponseBody(httpState, httpConnection);
        this.processResponseBody(httpState, httpConnection);
    }

    protected void readResponseBody(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.readResponseBody(HttpState, HttpConnection)");
        InputStream inputStream = this.readResponseBody(httpConnection);
        if (inputStream == null) {
            this.responseBodyConsumed();
        } else {
            httpConnection.setLastResponseInputStream(inputStream);
            this.setResponseStream(inputStream);
        }
    }

    private InputStream readResponseBody(HttpConnection httpConnection) throws HttpException, IOException {
        LOG.trace("enter HttpMethodBase.readResponseBody(HttpConnection)");
        this.responseBody = null;
        InputStream inputStream = httpConnection.getResponseInputStream();
        if (Wire.CONTENT_WIRE.enabled()) {
            inputStream = new WireLogInputStream(inputStream, Wire.CONTENT_WIRE);
        }
        boolean bl2 = HttpMethodBase.canResponseHaveBody(this.statusLine.getStatusCode());
        InputStream inputStream2 = null;
        Header header = this.responseHeaders.getFirstHeader("Transfer-Encoding");
        if (header != null) {
            HeaderElement[] headerElementArray;
            int n2;
            String string = header.getValue();
            if (!"chunked".equalsIgnoreCase(string) && !"identity".equalsIgnoreCase(string) && LOG.isWarnEnabled()) {
                LOG.warn("Unsupported transfer encoding: " + string);
            }
            if ((n2 = (headerElementArray = header.getElements()).length) > 0 && "chunked".equalsIgnoreCase(headerElementArray[n2 - 1].getName())) {
                if (httpConnection.isResponseAvailable(httpConnection.getParams().getSoTimeout())) {
                    inputStream2 = new ChunkedInputStream(inputStream, this);
                } else {
                    if (this.getParams().isParameterTrue("http.protocol.strict-transfer-encoding")) {
                        throw new ProtocolException("Chunk-encoded body declared but not sent");
                    }
                    LOG.warn("Chunk-encoded body missing");
                }
            } else {
                LOG.info("Response content is not chunk-encoded");
                this.setConnectionCloseForced(true);
                inputStream2 = inputStream;
            }
        } else {
            long l2 = this.getResponseContentLength();
            if (l2 == -1L) {
                if (bl2 && this.effectiveVersion.greaterEquals(HttpVersion.HTTP_1_1)) {
                    Header header2 = this.responseHeaders.getFirstHeader("Connection");
                    String string = null;
                    if (header2 != null) {
                        string = header2.getValue();
                    }
                    if (!"close".equalsIgnoreCase(string)) {
                        LOG.info("Response content length is not known");
                        this.setConnectionCloseForced(true);
                    }
                }
                inputStream2 = inputStream;
            } else {
                inputStream2 = new ContentLengthInputStream(inputStream, l2);
            }
        }
        if (!bl2) {
            inputStream2 = null;
        }
        if (inputStream2 != null) {
            inputStream2 = new AutoCloseInputStream(inputStream2, new ResponseConsumedWatcher(){

                public void responseConsumed() {
                    HttpMethodBase.this.responseBodyConsumed();
                }
            });
        }
        return inputStream2;
    }

    protected void readResponseHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.readResponseHeaders(HttpState,HttpConnection)");
        this.getResponseHeaderGroup().clear();
        Header[] headerArray = HttpParser.parseHeaders(httpConnection.getResponseInputStream(), this.getParams().getHttpElementCharset());
        if (Wire.HEADER_WIRE.enabled()) {
            for (int i2 = 0; i2 < headerArray.length; ++i2) {
                Wire.HEADER_WIRE.input(headerArray[i2].toExternalForm());
            }
        }
        this.getResponseHeaderGroup().setHeaders(headerArray);
    }

    protected void readStatusLine(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        String string;
        LOG.trace("enter HttpMethodBase.readStatusLine(HttpState, HttpConnection)");
        int n2 = this.getParams().getIntParameter("http.protocol.status-line-garbage-limit", Integer.MAX_VALUE);
        int n3 = 0;
        while (true) {
            if ((string = httpConnection.readLine(this.getParams().getHttpElementCharset())) == null && n3 == 0) {
                throw new NoHttpResponseException("The server " + httpConnection.getHost() + " failed to respond");
            }
            if (Wire.HEADER_WIRE.enabled()) {
                Wire.HEADER_WIRE.input(string + "\r\n");
            }
            if (string != null && StatusLine.startsWithHTTP(string)) break;
            if (string == null || n3 >= n2) {
                throw new ProtocolException("The server " + httpConnection.getHost() + " failed to respond with a valid HTTP response");
            }
            ++n3;
        }
        this.statusLine = new StatusLine(string);
        String string2 = this.statusLine.getHttpVersion();
        if (this.getParams().isParameterFalse("http.protocol.unambiguous-statusline") && string2.equals("HTTP")) {
            this.getParams().setVersion(HttpVersion.HTTP_1_0);
            if (LOG.isWarnEnabled()) {
                LOG.warn("Ambiguous status line (HTTP protocol version missing):" + this.statusLine.toString());
            }
        } else {
            this.effectiveVersion = HttpVersion.parse(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRequest(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.writeRequest(HttpState, HttpConnection)");
        this.writeRequestLine(httpState, httpConnection);
        this.writeRequestHeaders(httpState, httpConnection);
        httpConnection.writeLine();
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output("\r\n");
        }
        HttpVersion httpVersion = this.getParams().getVersion();
        Header header = this.getRequestHeader("Expect");
        String string = null;
        if (header != null) {
            string = header.getValue();
        }
        if (string != null && string.compareToIgnoreCase("100-continue") == 0) {
            if (httpVersion.greaterEquals(HttpVersion.HTTP_1_1)) {
                httpConnection.flushRequestOutputStream();
                int n2 = httpConnection.getParams().getSoTimeout();
                try {
                    httpConnection.setSocketTimeout(3000);
                    this.readStatusLine(httpState, httpConnection);
                    this.processStatusLine(httpState, httpConnection);
                    this.readResponseHeaders(httpState, httpConnection);
                    this.processResponseHeaders(httpState, httpConnection);
                    if (this.statusLine.getStatusCode() == 100) {
                        this.statusLine = null;
                        LOG.debug("OK to continue received");
                    }
                    return;
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (!ExceptionUtil.isSocketTimeoutException(interruptedIOException)) {
                        throw interruptedIOException;
                    }
                    this.removeRequestHeader("Expect");
                    LOG.info("100 (continue) read timeout. Resume sending the request");
                }
                finally {
                    httpConnection.setSocketTimeout(n2);
                }
            } else {
                this.removeRequestHeader("Expect");
                LOG.info("'Expect: 100-continue' handshake is only supported by HTTP/1.1 or higher");
            }
        }
        this.writeRequestBody(httpState, httpConnection);
        httpConnection.flushRequestOutputStream();
    }

    protected boolean writeRequestBody(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        return true;
    }

    protected void writeRequestHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.writeRequestHeaders(HttpState,HttpConnection)");
        this.addRequestHeaders(httpState, httpConnection);
        String string = this.getParams().getHttpElementCharset();
        Header[] headerArray = this.getRequestHeaders();
        for (int i2 = 0; i2 < headerArray.length; ++i2) {
            String string2 = headerArray[i2].toExternalForm();
            if (Wire.HEADER_WIRE.enabled()) {
                Wire.HEADER_WIRE.output(string2);
            }
            httpConnection.print(string2, string);
        }
    }

    protected void writeRequestLine(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.writeRequestLine(HttpState, HttpConnection)");
        String string = this.getRequestLine(httpConnection);
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output(string);
        }
        httpConnection.print(string, this.getParams().getHttpElementCharset());
    }

    private String getRequestLine(HttpConnection httpConnection) {
        return HttpMethodBase.generateRequestLine(httpConnection, this.getName(), this.getPath(), this.getQueryString(), this.effectiveVersion.toString());
    }

    public HttpMethodParams getParams() {
        return this.params;
    }

    public void setParams(HttpMethodParams httpMethodParams) {
        if (httpMethodParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = httpMethodParams;
    }

    public HttpVersion getEffectiveVersion() {
        return this.effectiveVersion;
    }

    private static boolean canResponseHaveBody(int n2) {
        LOG.trace("enter HttpMethodBase.canResponseHaveBody(int)");
        boolean bl2 = true;
        if (n2 >= 100 && n2 <= 199 || n2 == 204 || n2 == 304) {
            bl2 = false;
        }
        return bl2;
    }

    public String getProxyAuthenticationRealm() {
        return this.proxyAuthState.getRealm();
    }

    public String getAuthenticationRealm() {
        return this.hostAuthState.getRealm();
    }

    protected String getContentCharSet(Header header) {
        NameValuePair nameValuePair;
        HeaderElement[] headerElementArray;
        LOG.trace("enter getContentCharSet( Header contentheader )");
        String string = null;
        if (header != null && (headerElementArray = header.getElements()).length == 1 && (nameValuePair = headerElementArray[0].getParameterByName("charset")) != null) {
            string = nameValuePair.getValue();
        }
        if (string == null) {
            string = this.getParams().getContentCharset();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Default charset used: " + string);
            }
        }
        return string;
    }

    public String getRequestCharSet() {
        return this.getContentCharSet(this.getRequestHeader("Content-Type"));
    }

    public String getResponseCharSet() {
        return this.getContentCharSet(this.getResponseHeader("Content-Type"));
    }

    public int getRecoverableExceptionCount() {
        return this.recoverableExceptionCount;
    }

    protected void responseBodyConsumed() {
        this.responseStream = null;
        if (this.responseConnection != null) {
            this.responseConnection.setLastResponseInputStream(null);
            if (this.shouldCloseConnection(this.responseConnection)) {
                this.responseConnection.close();
            } else {
                try {
                    if (this.responseConnection.isResponseAvailable()) {
                        boolean bl2 = this.getParams().isParameterTrue("http.protocol.warn-extra-input");
                        if (bl2) {
                            LOG.warn("Extra response data detected - closing connection");
                        }
                        this.responseConnection.close();
                    }
                }
                catch (IOException iOException) {
                    LOG.warn(iOException.getMessage());
                    this.responseConnection.close();
                }
            }
        }
        this.connectionCloseForced = false;
        this.ensureConnectionRelease();
    }

    private void ensureConnectionRelease() {
        if (this.responseConnection != null) {
            this.responseConnection.releaseConnection();
            this.responseConnection = null;
        }
    }

    public HostConfiguration getHostConfiguration() {
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(this.httphost);
        return hostConfiguration;
    }

    public void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.httphost = hostConfiguration != null ? new HttpHost(hostConfiguration.getHost(), hostConfiguration.getPort(), hostConfiguration.getProtocol()) : null;
    }

    public MethodRetryHandler getMethodRetryHandler() {
        return this.methodRetryHandler;
    }

    public void setMethodRetryHandler(MethodRetryHandler methodRetryHandler) {
        this.methodRetryHandler = methodRetryHandler;
    }

    void fakeResponse(StatusLine statusLine, HeaderGroup headerGroup, InputStream inputStream) {
        this.used = true;
        this.statusLine = statusLine;
        this.responseHeaders = headerGroup;
        this.responseBody = null;
        this.responseStream = inputStream;
    }

    public AuthState getHostAuthState() {
        return this.hostAuthState;
    }

    public AuthState getProxyAuthState() {
        return this.proxyAuthState;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isRequestSent() {
        return this.requestSent;
    }
}

