/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpConstants {
    public static final String HTTP_ELEMENT_CHARSET = "US-ASCII";
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private static final Log LOG = LogFactory.getLog(HttpConstants.class);

    public static byte[] getBytes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return string.getBytes(HTTP_ELEMENT_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: US-ASCII. System default encoding used");
            }
            return string.getBytes();
        }
    }

    public static String getString(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(byArray, n2, n3, HTTP_ELEMENT_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: US-ASCII. System default encoding used");
            }
            return new String(byArray, n2, n3);
        }
    }

    public static String getString(byte[] byArray) {
        return HttpConstants.getString(byArray, 0, byArray.length);
    }

    public static byte[] getContentBytes(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (string2 == null || string2.equals("")) {
            string2 = DEFAULT_CONTENT_CHARSET;
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: " + string2 + ". HTTP default encoding used");
            }
            try {
                return string.getBytes(DEFAULT_CONTENT_CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Unsupported encoding: ISO-8859-1. System encoding used");
                }
                return string.getBytes();
            }
        }
    }

    public static String getContentString(byte[] byArray, int n2, int n3, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (string == null || string.equals("")) {
            string = DEFAULT_CONTENT_CHARSET;
        }
        try {
            return new String(byArray, n2, n3, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: " + string + ". Default HTTP encoding used");
            }
            try {
                return new String(byArray, n2, n3, DEFAULT_CONTENT_CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Unsupported encoding: ISO-8859-1. System encoding used");
                }
                return new String(byArray, n2, n3);
            }
        }
    }

    public static String getContentString(byte[] byArray, String string) {
        return HttpConstants.getContentString(byArray, 0, byArray.length, string);
    }

    public static byte[] getContentBytes(String string) {
        return HttpConstants.getContentBytes(string, null);
    }

    public static String getContentString(byte[] byArray, int n2, int n3) {
        return HttpConstants.getContentString(byArray, n2, n3, null);
    }

    public static String getContentString(byte[] byArray) {
        return HttpConstants.getContentString(byArray, null);
    }

    public static byte[] getAsciiBytes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return string.getBytes(HTTP_ELEMENT_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(byArray, n2, n3, HTTP_ELEMENT_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] byArray) {
        return HttpConstants.getAsciiString(byArray, 0, byArray.length);
    }
}

