/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.ChunkedInputStream;

public class ContentLengthInputStream
extends InputStream {
    private long contentLength;
    private long pos = 0L;
    private boolean closed = false;
    private InputStream wrappedStream = null;

    public ContentLengthInputStream(InputStream inputStream, int n2) {
        this(inputStream, (long)n2);
    }

    public ContentLengthInputStream(InputStream inputStream, long l2) {
        this.wrappedStream = inputStream;
        this.contentLength = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            try {
                ChunkedInputStream.exhaustInputStream(this);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        ++this.pos;
        return this.wrappedStream.read();
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        if (this.pos + (long)n3 > this.contentLength) {
            n3 = (int)(this.contentLength - this.pos);
        }
        int n4 = this.wrappedStream.read(byArray, n2, n3);
        this.pos += (long)n4;
        return n4;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public long skip(long l2) throws IOException {
        long l3 = Math.min(l2, this.contentLength - this.pos);
        if ((l3 = this.wrappedStream.skip(l3)) > 0L) {
            this.pos += l3;
        }
        return l3;
    }

    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        int n2 = this.wrappedStream.available();
        if (this.pos + (long)n2 > this.contentLength) {
            n2 = (int)(this.contentLength - this.pos);
        }
        return n2;
    }
}

