/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.httpclient.util.ExceptionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private int chunkSize;
    private int pos;
    private boolean bof = true;
    private boolean eof = false;
    private boolean closed = false;
    private HttpMethod method = null;
    private static final Log LOG = LogFactory.getLog(ChunkedInputStream.class);

    public ChunkedInputStream(InputStream inputStream, HttpMethod httpMethod) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream parameter may not be null");
        }
        this.in = inputStream;
        this.method = httpMethod;
        this.pos = 0;
    }

    public ChunkedInputStream(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        ++this.pos;
        return this.in.read();
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        n3 = Math.min(n3, this.chunkSize - this.pos);
        int n4 = this.in.read(byArray, n2, n3);
        this.pos += n4;
        return n4;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    private void readCRLF() throws IOException {
        int n2 = this.in.read();
        int n3 = this.in.read();
        if (n2 != 13 || n3 != 10) {
            throw new IOException("CRLF expected at end of chunk: " + n2 + "/" + n3);
        }
    }

    private void nextChunk() throws IOException {
        if (!this.bof) {
            this.readCRLF();
        }
        this.chunkSize = ChunkedInputStream.getChunkSizeFromInputStream(this.in);
        this.bof = false;
        this.pos = 0;
        if (this.chunkSize == 0) {
            this.eof = true;
            this.parseTrailerHeaders();
        }
    }

    private static int getChunkSizeFromInputStream(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        block15: while (n3 != -1) {
            int n4 = inputStream.read();
            if (n4 == -1) {
                throw new IOException("chunked stream ended unexpectedly");
            }
            switch (n3) {
                case 0: {
                    switch (n4) {
                        case 13: {
                            n3 = 1;
                            continue block15;
                        }
                        case 34: {
                            n3 = 2;
                        }
                    }
                    byteArrayOutputStream.write(n4);
                    continue block15;
                }
                case 1: {
                    if (n4 == 10) {
                        n3 = -1;
                        continue block15;
                    }
                    throw new IOException("Protocol violation: Unexpected single newline character in chunk size");
                }
                case 2: {
                    switch (n4) {
                        case 92: {
                            n4 = inputStream.read();
                            byteArrayOutputStream.write(n4);
                            continue block15;
                        }
                        case 34: {
                            n3 = 0;
                        }
                    }
                    byteArrayOutputStream.write(n4);
                    continue block15;
                }
            }
            throw new RuntimeException("assertion failed");
        }
        String string = EncodingUtil.getAsciiString(byteArrayOutputStream.toByteArray());
        int n5 = string.indexOf(59);
        string = n5 > 0 ? string.substring(0, n5).trim() : string.trim();
        try {
            n2 = Integer.parseInt(string.trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad chunk size: " + string);
        }
        return n2;
    }

    private void parseTrailerHeaders() throws IOException {
        Header[] headerArray = null;
        try {
            String string = "US-ASCII";
            if (this.method != null) {
                string = this.method.getParams().getHttpElementCharset();
            }
            headerArray = HttpParser.parseHeaders(this.in, string);
        }
        catch (HttpException httpException) {
            LOG.error("Error parsing trailer headers", httpException);
            IOException iOException = new IOException(httpException.getMessage());
            ExceptionUtil.initCause(iOException, httpException);
            throw iOException;
        }
        if (this.method != null) {
            for (int i2 = 0; i2 < headerArray.length; ++i2) {
                this.method.addResponseFooter(headerArray[i2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof) {
                    ChunkedInputStream.exhaustInputStream(this);
                }
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }

    static void exhaustInputStream(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        while (inputStream.read(byArray) >= 0) {
        }
    }
}

