/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.ResponseConsumedWatcher;

class AutoCloseInputStream
extends FilterInputStream {
    private boolean streamOpen = true;
    private boolean selfClosed = false;
    private ResponseConsumedWatcher watcher = null;

    public AutoCloseInputStream(InputStream inputStream, ResponseConsumedWatcher responseConsumedWatcher) {
        super(inputStream);
        this.watcher = responseConsumedWatcher;
    }

    public int read() throws IOException {
        int n2 = -1;
        if (this.isReadAllowed()) {
            n2 = super.read();
            this.checkClose(n2);
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = -1;
        if (this.isReadAllowed()) {
            n4 = super.read(byArray, n2, n3);
            this.checkClose(n4);
        }
        return n4;
    }

    public int read(byte[] byArray) throws IOException {
        int n2 = -1;
        if (this.isReadAllowed()) {
            n2 = super.read(byArray);
            this.checkClose(n2);
        }
        return n2;
    }

    public int available() throws IOException {
        int n2 = 0;
        if (this.isReadAllowed()) {
            n2 = super.available();
        }
        return n2;
    }

    public void close() throws IOException {
        if (!this.selfClosed) {
            this.selfClosed = true;
            this.notifyWatcher();
        }
    }

    private void checkClose(int n2) throws IOException {
        if (n2 == -1) {
            this.notifyWatcher();
        }
    }

    private boolean isReadAllowed() throws IOException {
        if (!this.streamOpen && this.selfClosed) {
            throw new IOException("Attempted read on closed stream.");
        }
        return this.streamOpen;
    }

    private void notifyWatcher() throws IOException {
        if (this.streamOpen) {
            super.close();
            this.streamOpen = false;
            if (this.watcher != null) {
                this.watcher.responseConsumed();
            }
        }
    }
}

