/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;

public class URLCodec
implements BinaryEncoder,
BinaryDecoder,
StringEncoder,
StringDecoder {
    protected String charset = "UTF-8";
    protected static byte ESCAPE_CHAR;
    protected static final BitSet WWW_FORM_URL;

    public URLCodec() {
    }

    public URLCodec(String string) {
        this.charset = string;
    }

    public static final byte[] encodeUrl(BitSet bitSet, byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (bitSet == null) {
            bitSet = WWW_FORM_URL;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            if (bitSet.get(n2)) {
                if (n2 == 32) {
                    n2 = 43;
                }
                byteArrayOutputStream.write(n2);
                continue;
            }
            byteArrayOutputStream.write(37);
            char c2 = Character.toUpperCase(Character.forDigit(n2 >> 4 & 0xF, 16));
            char c3 = Character.toUpperCase(Character.forDigit(n2 & 0xF, 16));
            byteArrayOutputStream.write(c2);
            byteArrayOutputStream.write(c3);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] decodeUrl(byte[] byArray) throws DecoderException {
        if (byArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by2 = byArray[i2];
            if (by2 == 43) {
                byteArrayOutputStream.write(32);
                continue;
            }
            if (by2 == 37) {
                try {
                    int n2 = Character.digit((char)byArray[++i2], 16);
                    int n3 = Character.digit((char)byArray[++i2], 16);
                    if (n2 == -1 || n3 == -1) {
                        throw new DecoderException("Invalid URL encoding");
                    }
                    byteArrayOutputStream.write((char)((n2 << 4) + n3));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new DecoderException("Invalid URL encoding");
                }
            }
            byteArrayOutputStream.write(by2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] encode(byte[] byArray) {
        return URLCodec.encodeUrl(WWW_FORM_URL, byArray);
    }

    public byte[] decode(byte[] byArray) throws DecoderException {
        return URLCodec.decodeUrl(byArray);
    }

    public String encode(String string, String string2) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return new String(this.encode(string.getBytes(string2)), "US-ASCII");
    }

    public String encode(String string) throws EncoderException {
        if (string == null) {
            return null;
        }
        try {
            return this.encode(string, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncoderException(unsupportedEncodingException.getMessage());
        }
    }

    public String decode(String string, String string2) throws DecoderException, UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return new String(this.decode(string.getBytes("US-ASCII")), string2);
    }

    public String decode(String string) throws DecoderException {
        if (string == null) {
            return null;
        }
        try {
            return this.decode(string, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DecoderException(unsupportedEncodingException.getMessage());
        }
    }

    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.encode((byte[])object);
        }
        if (object instanceof String) {
            return this.encode((String)object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be URL encoded");
    }

    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be URL decoded");
    }

    public String getEncoding() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset;
    }

    static {
        int n2;
        ESCAPE_CHAR = (byte)37;
        WWW_FORM_URL = new BitSet(256);
        for (n2 = 97; n2 <= 122; ++n2) {
            WWW_FORM_URL.set(n2);
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            WWW_FORM_URL.set(n2);
        }
        for (n2 = 48; n2 <= 57; ++n2) {
            WWW_FORM_URL.set(n2);
        }
        WWW_FORM_URL.set(45);
        WWW_FORM_URL.set(95);
        WWW_FORM_URL.set(46);
        WWW_FORM_URL.set(42);
        WWW_FORM_URL.set(32);
    }
}

