/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

abstract class RFC1522Codec {
    RFC1522Codec() {
    }

    protected String encodeText(String string, String string2) throws EncoderException, UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=?");
        stringBuffer.append(string2);
        stringBuffer.append('?');
        stringBuffer.append(this.getEncoding());
        stringBuffer.append('?');
        byte[] byArray = this.doEncoding(string.getBytes(string2));
        stringBuffer.append(new String(byArray, "US-ASCII"));
        stringBuffer.append("?=");
        return stringBuffer.toString();
    }

    protected String decodeText(String string) throws DecoderException, UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("=?") || !string.endsWith("?=")) {
            throw new DecoderException("RFC 1522 violation: malformed encoded content");
        }
        int n2 = string.length() - 2;
        int n3 = 2;
        int n4 = string.indexOf("?", n3);
        if (n4 == -1 || n4 == n2) {
            throw new DecoderException("RFC 1522 violation: charset token not found");
        }
        String string2 = string.substring(n3, n4);
        if (string2.equals("")) {
            throw new DecoderException("RFC 1522 violation: charset not specified");
        }
        n3 = n4 + 1;
        if ((n4 = string.indexOf("?", n3)) == -1 || n4 == n2) {
            throw new DecoderException("RFC 1522 violation: encoding token not found");
        }
        String string3 = string.substring(n3, n4);
        if (!this.getEncoding().equalsIgnoreCase(string3)) {
            throw new DecoderException("This codec cannot decode " + string3 + " encoded content");
        }
        n3 = n4 + 1;
        n4 = string.indexOf("?", n3);
        byte[] byArray = string.substring(n3, n4).getBytes("US-ASCII");
        byArray = this.doDecoding(byArray);
        return new String(byArray, string2);
    }

    protected abstract String getEncoding();

    protected abstract byte[] doEncoding(byte[] var1) throws EncoderException;

    protected abstract byte[] doDecoding(byte[] var1) throws DecoderException;
}

