/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.SoundexUtils;

public class Soundex
implements StringEncoder {
    public static final Soundex US_ENGLISH = new Soundex();
    public static final String US_ENGLISH_MAPPING_STRING = "01230120022455012623010202";
    public static final char[] US_ENGLISH_MAPPING = "01230120022455012623010202".toCharArray();
    private int maxLength = 4;
    private char[] soundexMapping;

    public int difference(String string, String string2) throws EncoderException {
        return SoundexUtils.difference(this, string, string2);
    }

    public Soundex() {
        this(US_ENGLISH_MAPPING);
    }

    public Soundex(char[] cArray) {
        this.setSoundexMapping(cArray);
    }

    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to Soundex encode is not of type java.lang.String");
        }
        return this.soundex((String)object);
    }

    public String encode(String string) {
        return this.soundex(string);
    }

    private char getMappingCode(String string, int n2) {
        char c2;
        char c3;
        char c4;
        char c5 = this.map(string.charAt(n2));
        if (!(n2 <= 1 || c5 == '0' || 'H' != (c4 = string.charAt(n2 - 1)) && 'W' != c4 || (c3 = this.map(c2 = string.charAt(n2 - 2))) != c5 && 'H' != c2 && 'W' != c2)) {
            return '\u0000';
        }
        return c5;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    private char[] getSoundexMapping() {
        return this.soundexMapping;
    }

    private char map(char c2) {
        int n2 = c2 - 65;
        if (n2 < 0 || n2 >= this.getSoundexMapping().length) {
            throw new IllegalArgumentException("The character is not mapped: " + c2);
        }
        return this.getSoundexMapping()[n2];
    }

    public void setMaxLength(int n2) {
        this.maxLength = n2;
    }

    private void setSoundexMapping(char[] cArray) {
        this.soundexMapping = cArray;
    }

    public String soundex(String string) {
        if (string == null) {
            return null;
        }
        if ((string = SoundexUtils.clean(string)).length() == 0) {
            return string;
        }
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 1;
        int n3 = 1;
        cArray[0] = string.charAt(0);
        char c2 = this.getMappingCode(string, 0);
        while (n2 < string.length() && n3 < cArray.length) {
            char c3;
            if ((c3 = this.getMappingCode(string, n2++)) == '\u0000') continue;
            if (c3 != '0' && c3 != c2) {
                cArray[n3++] = c3;
            }
            c2 = c3;
        }
        return new String(cArray);
    }
}

