/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

public class Hex
implements BinaryEncoder,
BinaryDecoder {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] decodeHex(char[] cArray) throws DecoderException {
        int n2 = cArray.length;
        if ((n2 & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        byte[] byArray = new byte[n2 >> 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = Hex.toDigit(cArray[n4], n4) << 4;
            n5 |= Hex.toDigit(cArray[++n4], n4);
            ++n4;
            byArray[n3] = (byte)(n5 & 0xFF);
            ++n3;
        }
        return byArray;
    }

    protected static int toDigit(char c2, int n2) throws DecoderException {
        int n3 = Character.digit(c2, 16);
        if (n3 == -1) {
            throw new DecoderException("Illegal hexadecimal charcter " + c2 + " at index " + n2);
        }
        return n3;
    }

    public static char[] encodeHex(byte[] byArray) {
        int n2 = byArray.length;
        char[] cArray = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[n3++] = DIGITS[(0xF0 & byArray[i2]) >>> 4];
            cArray[n3++] = DIGITS[0xF & byArray[i2]];
        }
        return cArray;
    }

    public byte[] decode(byte[] byArray) throws DecoderException {
        return Hex.decodeHex(new String(byArray).toCharArray());
    }

    public Object decode(Object object) throws DecoderException {
        try {
            char[] cArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            return Hex.decodeHex(cArray);
        }
        catch (ClassCastException classCastException) {
            throw new DecoderException(classCastException.getMessage());
        }
    }

    public byte[] encode(byte[] byArray) {
        return new String(Hex.encodeHex(byArray)).getBytes();
    }

    public Object encode(Object object) throws EncoderException {
        try {
            byte[] byArray = object instanceof String ? ((String)object).getBytes() : (byte[])object;
            return Hex.encodeHex(byArray);
        }
        catch (ClassCastException classCastException) {
            throw new EncoderException(classCastException.getMessage());
        }
    }
}

